/*! For license information please see settings-vue-settings-admin-ai.js.LICENSE.txt */
(()=>{var e,n={35594:(e,n,o)=>{"use strict";var r=o(20144),i=o(93664),a=o(34741),s=o(67912),l=o(86884),c=o(74628),u=o(9980),d=o.n(u);const f={name:"DragVerticalIcon",emits:["click"],props:{title:{type:String},fillColor:{type:String,default:"currentColor"},size:{type:Number,default:24}}};var p=o(51900);const h=(0,p.Z)(f,(function(){var t=this,e=t._self._c;return e("span",t._b({staticClass:"material-design-icon drag-vertical-icon",attrs:{"aria-hidden":!t.title,"aria-label":t.title,role:"img"},on:{click:function(e){return t.$emit("click",e)}}},"span",t.$attrs,!1),[e("svg",{staticClass:"material-design-icon__svg",attrs:{fill:t.fillColor,width:t.size,height:t.size,viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M9,3H11V5H9V3M13,3H15V5H13V3M9,7H11V9H9V7M13,7H15V9H13V7M9,11H11V13H9V11M13,11H15V13H13V11M9,15H11V17H9V15M13,15H15V17H13V15M9,19H11V21H9V19M13,19H15V21H13V19Z"}},[t.title?e("title",[t._v(t._s(t.title))]):t._e()])])])}),[],!1,null,null,null).exports;var g=o(59060),v=o(11573),m=o(43554),b=o(79753),y=o(25108);const x={name:"AdminAI",components:{NcCheckboxRadioSwitch:a.Z,NcSettingsSection:s.Z,NcSelect:l.Z,draggable:d(),DragVerticalIcon:h,ArrowDownIcon:g.Z,ArrowUpIcon:v.Z,NcButton:c.Z},data:()=>({loading:!1,dirty:!1,groups:[],loadingGroups:!1,sttProviders:(0,m.j)("settings","ai-stt-providers"),translationProviders:(0,m.j)("settings","ai-translation-providers"),textProcessingProviders:(0,m.j)("settings","ai-text-processing-providers"),textProcessingTaskTypes:(0,m.j)("settings","ai-text-processing-task-types"),text2imageProviders:(0,m.j)("settings","ai-text2image-providers"),settings:(0,m.j)("settings","ai-settings")}),computed:{hasStt(){return this.sttProviders.length>0},hasTextProcessing(){return Object.keys(this.settings["ai.textprocessing_provider_preferences"]).length>0&&Array.isArray(this.textProcessingTaskTypes)},tpTaskTypes(){return Object.keys(this.settings["ai.textprocessing_provider_preferences"]).filter((t=>!!this.getTaskType(t)))},hasText2ImageProviders(){return this.text2imageProviders.length>0}},methods:{moveUp(t){this.settings["ai.translation_provider_preferences"].splice(Math.min(t-1,0),0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},moveDown(t){this.settings["ai.translation_provider_preferences"].splice(t+1,0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},async saveChanges(){this.loading=!0;const t={settings:this.settings};try{await i.Z.put((0,b.generateUrl)("/settings/api/admin/ai"),t)}catch(t){y.error("could not save changes",t)}this.loading=!1},getTaskType(t){return Array.isArray(this.textProcessingTaskTypes)?this.textProcessingTaskTypes.find((e=>e.class===t)):null}}};var w=o(93379),S=o.n(w),_=o(7795),C=o.n(_),A=o(90569),T=o.n(A),E=o(3565),D=o.n(E),O=o(19216),I=o.n(O),M=o(44589),N=o.n(M),k=o(27615),P={};P.styleTagTransform=N(),P.setAttributes=D(),P.insert=T().bind(null,"head"),P.domAPI=C(),P.insertStyleElement=I(),S()(k.Z,P),k.Z&&k.Z.locals&&k.Z.locals;const j=(0,p.Z)(x,(function(){var t=this,e=t._self._c;return e("div",[e("NcSettingsSection",{attrs:{name:t.t("settings","Machine translation"),description:t.t("settings","Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.")}},[e("draggable",{on:{change:t.saveChanges},model:{value:t.settings["ai.translation_provider_preferences"],callback:function(e){t.$set(t.settings,"ai.translation_provider_preferences",e)},expression:"settings['ai.translation_provider_preferences']"}},t._l(t.settings["ai.translation_provider_preferences"],(function(n,o){return e("div",{key:n,staticClass:"draggable__item"},[e("DragVerticalIcon"),t._v(" "),e("span",{staticClass:"draggable__number"},[t._v(t._s(o+1))]),t._v(" "+t._s(t.translationProviders.find((t=>t.class===n))?.name)+"\n\t\t\t\t"),e("NcButton",{attrs:{"aria-label":"Move up",type:"tertiary"},on:{click:function(e){return t.moveUp(o)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowUpIcon")]},proxy:!0}],null,!0)}),t._v(" "),e("NcButton",{attrs:{"aria-label":"Move down",type:"tertiary"},on:{click:function(e){return t.moveDown(o)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowDownIcon")]},proxy:!0}],null,!0)})],1)})),0)],1),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Speech-To-Text"),description:t.t("settings","Speech-To-Text can be implemented by different apps. Here you can set which app should be used.")}},[t._l(t.sttProviders,(function(n){return[e("NcCheckboxRadioSwitch",{key:n.class,attrs:{checked:t.settings["ai.stt_provider"],value:n.class,name:"stt_provider",type:"radio"},on:{"update:checked":[function(e){return t.$set(t.settings,"ai.stt_provider",e)},t.saveChanges]}},[t._v("\n\t\t\t\t"+t._s(n.name)+"\n\t\t\t")])]})),t._v(" "),t.hasStt?t._e():[e("NcCheckboxRadioSwitch",{attrs:{disabled:"",type:"radio"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide Speech-To-Text functionality"))+"\n\t\t\t")])]],2),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Image generation"),description:t.t("settings","Image generation can be implemented by different apps. Here you can set which app should be used.")}},[t._l(t.text2imageProviders,(function(n){return[e("NcCheckboxRadioSwitch",{key:n.id,attrs:{checked:t.settings["ai.text2image_provider"],value:n.id,name:"text2image_provider",type:"radio"},on:{"update:checked":[function(e){return t.$set(t.settings,"ai.text2image_provider",e)},t.saveChanges]}},[t._v("\n\t\t\t\t"+t._s(n.name)+"\n\t\t\t")])]})),t._v(" "),t.hasText2ImageProviders?t._e():[e("NcCheckboxRadioSwitch",{attrs:{disabled:"",type:"radio"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide image generation functionality"))+"\n\t\t\t")])]],2),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Text processing"),description:t.t("settings","Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.")}},[t._l(t.tpTaskTypes,(function(n){return[e("div",{key:n},[e("h3",[t._v(t._s(t.t("settings","Task:"))+" "+t._s(t.getTaskType(n).name))]),t._v(" "),e("p",[t._v(t._s(t.getTaskType(n).description))]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("NcSelect",{attrs:{clearable:!1,options:t.textProcessingProviders.filter((t=>t.taskType===n)).map((t=>t.class))},on:{input:t.saveChanges},scopedSlots:t._u([{key:"option",fn:function(e){let{label:n}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(t.textProcessingProviders.find((t=>t.class===n))?.name)+"\n\t\t\t\t\t")]}},{key:"selected-option",fn:function(e){let{label:n}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(t.textProcessingProviders.find((t=>t.class===n))?.name)+"\n\t\t\t\t\t")]}}],null,!0),model:{value:t.settings["ai.textprocessing_provider_preferences"][n],callback:function(e){t.$set(t.settings["ai.textprocessing_provider_preferences"],n,e)},expression:"settings['ai.textprocessing_provider_preferences'][type]"}}),t._v(" "),e("p",[t._v(" ")])],1)]})),t._v(" "),t.hasTextProcessing?t._e():[e("p",[t._v(t._s(t.t("settings","None of your currently installed apps provide Text processing functionality")))])]],2)],1)}),[],!1,null,"02386c8b",null).exports;o.nc=btoa(OC.requestToken),r.default.prototype.t=t,window.OC=window.OC||{},window.OC.Settings=window.OC.Settings||{},(new(r.default.extend(j))).$mount("#ai-settings")},27615:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.draggable__item[data-v-02386c8b] {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n.draggable__item[data-v-02386c8b],\n.draggable__item *[data-v-02386c8b] {\n  cursor: grab;\n}\n.draggable__number[data-v-02386c8b] {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n.drag-vertical-icon[data-v-02386c8b] {\n  float: left;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/AdminAI.vue"],names:[],mappings:";AA+KA;CACA,kBAAA;EACA,aAAA;EACA,mBAAA;AACA;AAEA;;EAEA,YAAA;AACA;AAEA;CACA,mBAAA;CACA,8CAAA;CACA,mCAAA;EACA,gBAAA;CACA,iBAAA;AACA;AAEA;EACA,WAAA;AACA",sourcesContent:["<template>\n\t<div>\n\t\t<NcSettingsSection :name=\"t('settings', 'Machine translation')\"\n\t\t\t:description=\"t('settings', 'Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.')\">\n\t\t\t<draggable v-model=\"settings['ai.translation_provider_preferences']\" @change=\"saveChanges\">\n\t\t\t\t<div v-for=\"(providerClass, i) in settings['ai.translation_provider_preferences']\" :key=\"providerClass\" class=\"draggable__item\">\n\t\t\t\t\t<DragVerticalIcon /> <span class=\"draggable__number\">{{ i + 1 }}</span> {{ translationProviders.find(p => p.class === providerClass)?.name }}\n\t\t\t\t\t<NcButton aria-label=\"Move up\" type=\"tertiary\" @click=\"moveUp(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowUpIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t\t<NcButton aria-label=\"Move down\" type=\"tertiary\" @click=\"moveDown(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowDownIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t</div>\n\t\t\t</draggable>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Speech-To-Text')\"\n\t\t\t:description=\"t('settings', 'Speech-To-Text can be implemented by different apps. Here you can set which app should be used.')\">\n\t\t\t<template v-for=\"provider in sttProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch :key=\"provider.class\"\n\t\t\t\t\t:checked.sync=\"settings['ai.stt_provider']\"\n\t\t\t\t\t:value=\"provider.class\"\n\t\t\t\t\tname=\"stt_provider\"\n\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t@update:checked=\"saveChanges\">\n\t\t\t\t\t{{ provider.name }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasStt\">\n\t\t\t\t<NcCheckboxRadioSwitch disabled type=\"radio\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide Speech-To-Text functionality') }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Image generation')\"\n\t\t\t:description=\"t('settings', 'Image generation can be implemented by different apps. Here you can set which app should be used.')\">\n\t\t\t<template v-for=\"provider in text2imageProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch :key=\"provider.id\"\n\t\t\t\t\t:checked.sync=\"settings['ai.text2image_provider']\"\n\t\t\t\t\t:value=\"provider.id\"\n\t\t\t\t\tname=\"text2image_provider\"\n\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t@update:checked=\"saveChanges\">\n\t\t\t\t\t{{ provider.name }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasText2ImageProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch disabled type=\"radio\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide image generation functionality') }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Text processing')\"\n\t\t\t:description=\"t('settings', 'Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.')\">\n\t\t\t<template v-for=\"type in tpTaskTypes\">\n\t\t\t\t<div :key=\"type\">\n\t\t\t\t\t<h3>{{ t('settings', 'Task:') }} {{ getTaskType(type).name }}</h3>\n\t\t\t\t\t<p>{{ getTaskType(type).description }}</p>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t\t<NcSelect v-model=\"settings['ai.textprocessing_provider_preferences'][type]\"\n\t\t\t\t\t\t:clearable=\"false\"\n\t\t\t\t\t\t:options=\"textProcessingProviders.filter(p => p.taskType === type).map(p => p.class)\"\n\t\t\t\t\t\t@input=\"saveChanges\">\n\t\t\t\t\t\t<template #option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template #selected-option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcSelect>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasTextProcessing\">\n\t\t\t\t<p>{{ t('settings', 'None of your currently installed apps provide Text processing functionality') }}</p>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t</div>\n</template>\n\n<script>\nimport axios from '@nextcloud/axios'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/dist/Components/NcCheckboxRadioSwitch.js'\nimport NcSettingsSection from '@nextcloud/vue/dist/Components/NcSettingsSection.js'\nimport NcSelect from '@nextcloud/vue/dist/Components/NcSelect.js'\nimport NcButton from '@nextcloud/vue/dist/Components/NcButton.js'\nimport draggable from 'vuedraggable'\nimport DragVerticalIcon from 'vue-material-design-icons/DragVertical.vue'\nimport ArrowDownIcon from 'vue-material-design-icons/ArrowDown.vue'\nimport ArrowUpIcon from 'vue-material-design-icons/ArrowUp.vue'\nimport { loadState } from '@nextcloud/initial-state'\n\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'AdminAI',\n\tcomponents: {\n\t\tNcCheckboxRadioSwitch,\n\t\tNcSettingsSection,\n\t\tNcSelect,\n\t\tdraggable,\n\t\tDragVerticalIcon,\n\t\tArrowDownIcon,\n\t\tArrowUpIcon,\n\t\tNcButton,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tloading: false,\n\t\t\tdirty: false,\n\t\t\tgroups: [],\n\t\t\tloadingGroups: false,\n\t\t\tsttProviders: loadState('settings', 'ai-stt-providers'),\n\t\t\ttranslationProviders: loadState('settings', 'ai-translation-providers'),\n\t\t\ttextProcessingProviders: loadState('settings', 'ai-text-processing-providers'),\n\t\t\ttextProcessingTaskTypes: loadState('settings', 'ai-text-processing-task-types'),\n\t\t\ttext2imageProviders: loadState('settings', 'ai-text2image-providers'),\n\t\t\tsettings: loadState('settings', 'ai-settings'),\n\t\t}\n\t},\n\tcomputed: {\n\t\thasStt() {\n\t\t\treturn this.sttProviders.length > 0\n\t\t},\n\t\thasTextProcessing() {\n\t\t\treturn Object.keys(this.settings['ai.textprocessing_provider_preferences']).length > 0 && Array.isArray(this.textProcessingTaskTypes)\n\t\t},\n\t\ttpTaskTypes() {\n\t\t\treturn Object.keys(this.settings['ai.textprocessing_provider_preferences']).filter(type => !!this.getTaskType(type))\n\t\t},\n\t\thasText2ImageProviders() {\n\t\t  return this.text2imageProviders.length > 0\n\t\t},\n\t},\n\tmethods: {\n\t  moveUp(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t  Math.min(i - 1, 0),\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1),\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tmoveDown(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t\ti + 1,\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1),\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tasync saveChanges() {\n\t\t\tthis.loading = true\n\t\t\tconst data = { settings: this.settings }\n\t\t\ttry {\n\t\t\t\tawait axios.put(generateUrl('/settings/api/admin/ai'), data)\n\t\t\t} catch (err) {\n\t\t\t\tconsole.error('could not save changes', err)\n\t\t\t}\n\t\t\tthis.loading = false\n\t\t},\n\t\tgetTaskType(type) {\n\t\t  if (!Array.isArray(this.textProcessingTaskTypes)) {\n\t\t\t\treturn null\n\t\t\t}\n\t\t\treturn this.textProcessingTaskTypes.find(taskType => taskType.class === type)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.draggable__item {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n\n.draggable__item,\n.draggable__item * {\n  cursor: grab;\n}\n\n.draggable__number {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n\n.drag-vertical-icon {\n  float: left;\n}\n</style>\n"],sourceRoot:""}]);const s=a},31715:(t,e,n)=>{"use strict";function o(t){return o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},o(t)}function r(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}function i(){return i=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},i.apply(this,arguments)}function a(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{},o=Object.keys(n);"function"==typeof Object.getOwnPropertySymbols&&(o=o.concat(Object.getOwnPropertySymbols(n).filter((function(t){return Object.getOwnPropertyDescriptor(n,t).enumerable})))),o.forEach((function(e){r(t,e,n[e])}))}return t}function s(t){if("undefined"!=typeof window&&window.navigator)return!!navigator.userAgent.match(t)}n.r(e),n.d(e,{MultiDrag:()=>ve,Sortable:()=>Rt,Swap:()=>ie,default:()=>ye});var l=s(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i),c=s(/Edge/i),u=s(/firefox/i),d=s(/safari/i)&&!s(/chrome/i)&&!s(/android/i),f=s(/iP(ad|od|hone)/i),p=s(/chrome/i)&&s(/android/i),h={capture:!1,passive:!1};function g(t,e,n){t.addEventListener(e,n,!l&&h)}function v(t,e,n){t.removeEventListener(e,n,!l&&h)}function m(t,e){if(e){if(">"===e[0]&&(e=e.substring(1)),t)try{if(t.matches)return t.matches(e);if(t.msMatchesSelector)return t.msMatchesSelector(e);if(t.webkitMatchesSelector)return t.webkitMatchesSelector(e)}catch(t){return!1}return!1}}function b(t){return t.host&&t!==document&&t.host.nodeType?t.host:t.parentNode}function y(t,e,n,o){if(t){n=n||document;do{if(null!=e&&(">"===e[0]?t.parentNode===n&&m(t,e):m(t,e))||o&&t===n)return t;if(t===n)break}while(t=b(t))}return null}var x,w=/\s+/g;function S(t,e,n){if(t&&e)if(t.classList)t.classList[n?"add":"remove"](e);else{var o=(" "+t.className+" ").replace(w," ").replace(" "+e+" "," ");t.className=(o+(n?" "+e:"")).replace(w," ")}}function _(t,e,n){var o=t&&t.style;if(o){if(void 0===n)return document.defaultView&&document.defaultView.getComputedStyle?n=document.defaultView.getComputedStyle(t,""):t.currentStyle&&(n=t.currentStyle),void 0===e?n:n[e];e in o||-1!==e.indexOf("webkit")||(e="-webkit-"+e),o[e]=n+("string"==typeof n?"":"px")}}function C(t,e){var n="";if("string"==typeof t)n=t;else do{var o=_(t,"transform");o&&"none"!==o&&(n=o+" "+n)}while(!e&&(t=t.parentNode));var r=window.DOMMatrix||window.WebKitCSSMatrix||window.CSSMatrix||window.MSCSSMatrix;return r&&new r(n)}function A(t,e,n){if(t){var o=t.getElementsByTagName(e),r=0,i=o.length;if(n)for(;r<i;r++)n(o[r],r);return o}return[]}function T(){return document.scrollingElement||document.documentElement}function E(t,e,n,o,r){if(t.getBoundingClientRect||t===window){var i,a,s,c,u,d,f;if(t!==window&&t!==T()?(a=(i=t.getBoundingClientRect()).top,s=i.left,c=i.bottom,u=i.right,d=i.height,f=i.width):(a=0,s=0,c=window.innerHeight,u=window.innerWidth,d=window.innerHeight,f=window.innerWidth),(e||n)&&t!==window&&(r=r||t.parentNode,!l))do{if(r&&r.getBoundingClientRect&&("none"!==_(r,"transform")||n&&"static"!==_(r,"position"))){var p=r.getBoundingClientRect();a-=p.top+parseInt(_(r,"border-top-width")),s-=p.left+parseInt(_(r,"border-left-width")),c=a+i.height,u=s+i.width;break}}while(r=r.parentNode);if(o&&t!==window){var h=C(r||t),g=h&&h.a,v=h&&h.d;h&&(c=(a/=v)+(d/=v),u=(s/=g)+(f/=g))}return{top:a,left:s,bottom:c,right:u,width:f,height:d}}}function D(t,e,n){for(var o=k(t,!0),r=E(t)[e];o;){var i=E(o)[n];if(!("top"===n||"left"===n?r>=i:r<=i))return o;if(o===T())break;o=k(o,!1)}return!1}function O(t,e,n){for(var o=0,r=0,i=t.children;r<i.length;){if("none"!==i[r].style.display&&i[r]!==Rt.ghost&&i[r]!==Rt.dragged&&y(i[r],n.draggable,t,!1)){if(o===e)return i[r];o++}r++}return null}function I(t,e){for(var n=t.lastElementChild;n&&(n===Rt.ghost||"none"===_(n,"display")||e&&!m(n,e));)n=n.previousElementSibling;return n||null}function M(t,e){var n=0;if(!t||!t.parentNode)return-1;for(;t=t.previousElementSibling;)"TEMPLATE"===t.nodeName.toUpperCase()||t===Rt.clone||e&&!m(t,e)||n++;return n}function N(t){var e=0,n=0,o=T();if(t)do{var r=C(t),i=r.a,a=r.d;e+=t.scrollLeft*i,n+=t.scrollTop*a}while(t!==o&&(t=t.parentNode));return[e,n]}function k(t,e){if(!t||!t.getBoundingClientRect)return T();var n=t,o=!1;do{if(n.clientWidth<n.scrollWidth||n.clientHeight<n.scrollHeight){var r=_(n);if(n.clientWidth<n.scrollWidth&&("auto"==r.overflowX||"scroll"==r.overflowX)||n.clientHeight<n.scrollHeight&&("auto"==r.overflowY||"scroll"==r.overflowY)){if(!n.getBoundingClientRect||n===document.body)return T();if(o||e)return n;o=!0}}}while(n=n.parentNode);return T()}function P(t,e){return Math.round(t.top)===Math.round(e.top)&&Math.round(t.left)===Math.round(e.left)&&Math.round(t.height)===Math.round(e.height)&&Math.round(t.width)===Math.round(e.width)}function j(t,e){return function(){if(!x){var n=arguments;1===n.length?t.call(this,n[0]):t.apply(this,n),x=setTimeout((function(){x=void 0}),e)}}}function L(t,e,n){t.scrollLeft+=e,t.scrollTop+=n}function R(t){var e=window.Polymer,n=window.jQuery||window.Zepto;return e&&e.dom?e.dom(t).cloneNode(!0):n?n(t).clone(!0)[0]:t.cloneNode(!0)}function B(t,e){_(t,"position","absolute"),_(t,"top",e.top),_(t,"left",e.left),_(t,"width",e.width),_(t,"height",e.height)}function H(t){_(t,"position",""),_(t,"top",""),_(t,"left",""),_(t,"width",""),_(t,"height","")}var F="Sortable"+(new Date).getTime();var Z=[],Y={initializeByDefault:!0},V={mount:function(t){for(var e in Y)Y.hasOwnProperty(e)&&!(e in t)&&(t[e]=Y[e]);Z.push(t)},pluginEvent:function(t,e,n){var o=this;this.eventCanceled=!1,n.cancel=function(){o.eventCanceled=!0};var r=t+"Global";Z.forEach((function(o){e[o.pluginName]&&(e[o.pluginName][r]&&e[o.pluginName][r](a({sortable:e},n)),e.options[o.pluginName]&&e[o.pluginName][t]&&e[o.pluginName][t](a({sortable:e},n)))}))},initializePlugins:function(t,e,n,o){for(var r in Z.forEach((function(o){var r=o.pluginName;if(t.options[r]||o.initializeByDefault){var a=new o(t,e,t.options);a.sortable=t,a.options=t.options,t[r]=a,i(n,a.defaults)}})),t.options)if(t.options.hasOwnProperty(r)){var a=this.modifyOption(t,r,t.options[r]);void 0!==a&&(t.options[r]=a)}},getEventProperties:function(t,e){var n={};return Z.forEach((function(o){"function"==typeof o.eventProperties&&i(n,o.eventProperties.call(e[o.pluginName],t))})),n},modifyOption:function(t,e,n){var o;return Z.forEach((function(r){t[r.pluginName]&&r.optionListeners&&"function"==typeof r.optionListeners[e]&&(o=r.optionListeners[e].call(t[r.pluginName],n))})),o}};function X(t){var e=t.sortable,n=t.rootEl,o=t.name,r=t.targetEl,i=t.cloneEl,s=t.toEl,u=t.fromEl,d=t.oldIndex,f=t.newIndex,p=t.oldDraggableIndex,h=t.newDraggableIndex,g=t.originalEvent,v=t.putSortable,m=t.extraEventProperties;if(e=e||n&&n[F]){var b,y=e.options,x="on"+o.charAt(0).toUpperCase()+o.substr(1);!window.CustomEvent||l||c?(b=document.createEvent("Event")).initEvent(o,!0,!0):b=new CustomEvent(o,{bubbles:!0,cancelable:!0}),b.to=s||n,b.from=u||n,b.item=r||n,b.clone=i,b.oldIndex=d,b.newIndex=f,b.oldDraggableIndex=p,b.newDraggableIndex=h,b.originalEvent=g,b.pullMode=v?v.lastPutMode:void 0;var w=a({},m,V.getEventProperties(o,e));for(var S in w)b[S]=w[S];n&&n.dispatchEvent(b),y[x]&&y[x].call(e,b)}}var U=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.evt,r=function(t,e){if(null==t)return{};var n,o,r=function(t,e){if(null==t)return{};var n,o,r={},i=Object.keys(t);for(o=0;o<i.length;o++)n=i[o],e.indexOf(n)>=0||(r[n]=t[n]);return r}(t,e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(t);for(o=0;o<i.length;o++)n=i[o],e.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(t,n)&&(r[n]=t[n])}return r}(n,["evt"]);V.pluginEvent.bind(Rt)(t,e,a({dragEl:z,parentEl:G,ghostEl:W,rootEl:K,nextEl:q,lastDownEl:Q,cloneEl:J,cloneHidden:tt,dragStarted:pt,putSortable:at,activeSortable:Rt.active,originalEvent:o,oldIndex:et,oldDraggableIndex:ot,newIndex:nt,newDraggableIndex:rt,hideGhostForTarget:kt,unhideGhostForTarget:Pt,cloneNowHidden:function(){tt=!0},cloneNowShown:function(){tt=!1},dispatchSortableEvent:function(t){$({sortable:e,name:t,originalEvent:o})}},r))};function $(t){X(a({putSortable:at,cloneEl:J,targetEl:z,rootEl:K,oldIndex:et,oldDraggableIndex:ot,newIndex:nt,newDraggableIndex:rt},t))}var z,G,W,K,q,Q,J,tt,et,nt,ot,rt,it,at,st,lt,ct,ut,dt,ft,pt,ht,gt,vt,mt,bt=!1,yt=!1,xt=[],wt=!1,St=!1,_t=[],Ct=!1,At=[],Tt="undefined"!=typeof document,Et=f,Dt=c||l?"cssFloat":"float",Ot=Tt&&!p&&!f&&"draggable"in document.createElement("div"),It=function(){if(Tt){if(l)return!1;var t=document.createElement("x");return t.style.cssText="pointer-events:auto","auto"===t.style.pointerEvents}}(),Mt=function(t,e){var n=_(t),o=parseInt(n.width)-parseInt(n.paddingLeft)-parseInt(n.paddingRight)-parseInt(n.borderLeftWidth)-parseInt(n.borderRightWidth),r=O(t,0,e),i=O(t,1,e),a=r&&_(r),s=i&&_(i),l=a&&parseInt(a.marginLeft)+parseInt(a.marginRight)+E(r).width,c=s&&parseInt(s.marginLeft)+parseInt(s.marginRight)+E(i).width;if("flex"===n.display)return"column"===n.flexDirection||"column-reverse"===n.flexDirection?"vertical":"horizontal";if("grid"===n.display)return n.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal";if(r&&a.float&&"none"!==a.float){var u="left"===a.float?"left":"right";return!i||"both"!==s.clear&&s.clear!==u?"horizontal":"vertical"}return r&&("block"===a.display||"flex"===a.display||"table"===a.display||"grid"===a.display||l>=o&&"none"===n[Dt]||i&&"none"===n[Dt]&&l+c>o)?"vertical":"horizontal"},Nt=function(t){function e(t,n){return function(o,r,i,a){var s=o.options.group.name&&r.options.group.name&&o.options.group.name===r.options.group.name;if(null==t&&(n||s))return!0;if(null==t||!1===t)return!1;if(n&&"clone"===t)return t;if("function"==typeof t)return e(t(o,r,i,a),n)(o,r,i,a);var l=(n?o:r).options.group.name;return!0===t||"string"==typeof t&&t===l||t.join&&t.indexOf(l)>-1}}var n={},r=t.group;r&&"object"==o(r)||(r={name:r}),n.name=r.name,n.checkPull=e(r.pull,!0),n.checkPut=e(r.put),n.revertClone=r.revertClone,t.group=n},kt=function(){!It&&W&&_(W,"display","none")},Pt=function(){!It&&W&&_(W,"display","")};Tt&&document.addEventListener("click",(function(t){if(yt)return t.preventDefault(),t.stopPropagation&&t.stopPropagation(),t.stopImmediatePropagation&&t.stopImmediatePropagation(),yt=!1,!1}),!0);var jt=function(t){if(z){t=t.touches?t.touches[0]:t;var e=(r=t.clientX,i=t.clientY,xt.some((function(t){if(!I(t)){var e=E(t),n=t[F].options.emptyInsertThreshold,o=r>=e.left-n&&r<=e.right+n,s=i>=e.top-n&&i<=e.bottom+n;return n&&o&&s?a=t:void 0}})),a);if(e){var n={};for(var o in t)t.hasOwnProperty(o)&&(n[o]=t[o]);n.target=n.rootEl=e,n.preventDefault=void 0,n.stopPropagation=void 0,e[F]._onDragOver(n)}}var r,i,a},Lt=function(t){z&&z.parentNode[F]._isOutsideThisEl(t.target)};function Rt(t,e){if(!t||!t.nodeType||1!==t.nodeType)throw"Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(t));this.el=t,this.options=e=i({},e),t[F]=this;var n,o,r={group:null,sort:!0,disabled:!1,store:null,handle:null,draggable:/^[uo]l$/i.test(t.nodeName)?">li":">*",swapThreshold:1,invertSwap:!1,invertedSwapThreshold:null,removeCloneOnHide:!0,direction:function(){return Mt(t,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,easing:null,setData:function(t,e){t.setData("Text",e.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,delayOnTouchOnly:!1,touchStartThreshold:(Number.parseInt?Number:window).parseInt(window.devicePixelRatio,10)||1,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:!1!==Rt.supportPointer&&"PointerEvent"in window,emptyInsertThreshold:5};for(var s in V.initializePlugins(this,t,r),r)!(s in e)&&(e[s]=r[s]);for(var l in Nt(e),this)"_"===l.charAt(0)&&"function"==typeof this[l]&&(this[l]=this[l].bind(this));this.nativeDraggable=!e.forceFallback&&Ot,this.nativeDraggable&&(this.options.touchStartThreshold=1),e.supportPointer?g(t,"pointerdown",this._onTapStart):(g(t,"mousedown",this._onTapStart),g(t,"touchstart",this._onTapStart)),this.nativeDraggable&&(g(t,"dragover",this),g(t,"dragenter",this)),xt.push(this.el),e.store&&e.store.get&&this.sort(e.store.get(this)||[]),i(this,(o=[],{captureAnimationState:function(){o=[],this.options.animation&&[].slice.call(this.el.children).forEach((function(t){if("none"!==_(t,"display")&&t!==Rt.ghost){o.push({target:t,rect:E(t)});var e=a({},o[o.length-1].rect);if(t.thisAnimationDuration){var n=C(t,!0);n&&(e.top-=n.f,e.left-=n.e)}t.fromRect=e}}))},addAnimationState:function(t){o.push(t)},removeAnimationState:function(t){o.splice(function(t,e){for(var n in t)if(t.hasOwnProperty(n))for(var o in e)if(e.hasOwnProperty(o)&&e[o]===t[n][o])return Number(n);return-1}(o,{target:t}),1)},animateAll:function(t){var e=this;if(!this.options.animation)return clearTimeout(n),void("function"==typeof t&&t());var r=!1,i=0;o.forEach((function(t){var n=0,o=t.target,a=o.fromRect,s=E(o),l=o.prevFromRect,c=o.prevToRect,u=t.rect,d=C(o,!0);d&&(s.top-=d.f,s.left-=d.e),o.toRect=s,o.thisAnimationDuration&&P(l,s)&&!P(a,s)&&(u.top-s.top)/(u.left-s.left)==(a.top-s.top)/(a.left-s.left)&&(n=function(t,e,n,o){return Math.sqrt(Math.pow(e.top-t.top,2)+Math.pow(e.left-t.left,2))/Math.sqrt(Math.pow(e.top-n.top,2)+Math.pow(e.left-n.left,2))*o.animation}(u,l,c,e.options)),P(s,a)||(o.prevFromRect=a,o.prevToRect=s,n||(n=e.options.animation),e.animate(o,u,s,n)),n&&(r=!0,i=Math.max(i,n),clearTimeout(o.animationResetTimer),o.animationResetTimer=setTimeout((function(){o.animationTime=0,o.prevFromRect=null,o.fromRect=null,o.prevToRect=null,o.thisAnimationDuration=null}),n),o.thisAnimationDuration=n)})),clearTimeout(n),r?n=setTimeout((function(){"function"==typeof t&&t()}),i):"function"==typeof t&&t(),o=[]},animate:function(t,e,n,o){if(o){_(t,"transition",""),_(t,"transform","");var r=C(this.el),i=r&&r.a,a=r&&r.d,s=(e.left-n.left)/(i||1),l=(e.top-n.top)/(a||1);t.animatingX=!!s,t.animatingY=!!l,_(t,"transform","translate3d("+s+"px,"+l+"px,0)"),function(t){t.offsetWidth}(t),_(t,"transition","transform "+o+"ms"+(this.options.easing?" "+this.options.easing:"")),_(t,"transform","translate3d(0,0,0)"),"number"==typeof t.animated&&clearTimeout(t.animated),t.animated=setTimeout((function(){_(t,"transition",""),_(t,"transform",""),t.animated=!1,t.animatingX=!1,t.animatingY=!1}),o)}}}))}function Bt(t,e,n,o,r,i,a,s){var u,d,f=t[F],p=f.options.onMove;return!window.CustomEvent||l||c?(u=document.createEvent("Event")).initEvent("move",!0,!0):u=new CustomEvent("move",{bubbles:!0,cancelable:!0}),u.to=e,u.from=t,u.dragged=n,u.draggedRect=o,u.related=r||e,u.relatedRect=i||E(e),u.willInsertAfter=s,u.originalEvent=a,t.dispatchEvent(u),p&&(d=p.call(f,u,a)),d}function Ht(t){t.draggable=!1}function Ft(){Ct=!1}function Zt(t){for(var e=t.tagName+t.className+t.src+t.href+t.textContent,n=e.length,o=0;n--;)o+=e.charCodeAt(n);return o.toString(36)}function Yt(t){return setTimeout(t,0)}function Vt(t){return clearTimeout(t)}Rt.prototype={constructor:Rt,_isOutsideThisEl:function(t){this.el.contains(t)||t===this.el||(ht=null)},_getDirection:function(t,e){return"function"==typeof this.options.direction?this.options.direction.call(this,t,e,z):this.options.direction},_onTapStart:function(t){if(t.cancelable){var e=this,n=this.el,o=this.options,r=o.preventOnFilter,i=t.type,a=t.touches&&t.touches[0]||t.pointerType&&"touch"===t.pointerType&&t,s=(a||t).target,l=t.target.shadowRoot&&(t.path&&t.path[0]||t.composedPath&&t.composedPath()[0])||s,c=o.filter;if(function(t){At.length=0;for(var e=t.getElementsByTagName("input"),n=e.length;n--;){var o=e[n];o.checked&&At.push(o)}}(n),!z&&!(/mousedown|pointerdown/.test(i)&&0!==t.button||o.disabled||l.isContentEditable||(s=y(s,o.draggable,n,!1))&&s.animated||Q===s)){if(et=M(s),ot=M(s,o.draggable),"function"==typeof c){if(c.call(this,t,s,this))return $({sortable:e,rootEl:l,name:"filter",targetEl:s,toEl:n,fromEl:n}),U("filter",e,{evt:t}),void(r&&t.cancelable&&t.preventDefault())}else if(c&&(c=c.split(",").some((function(o){if(o=y(l,o.trim(),n,!1))return $({sortable:e,rootEl:o,name:"filter",targetEl:s,fromEl:n,toEl:n}),U("filter",e,{evt:t}),!0}))))return void(r&&t.cancelable&&t.preventDefault());o.handle&&!y(l,o.handle,n,!1)||this._prepareDragStart(t,a,s)}}},_prepareDragStart:function(t,e,n){var o,r=this,i=r.el,a=r.options,s=i.ownerDocument;if(n&&!z&&n.parentNode===i){var d=E(n);if(K=i,G=(z=n).parentNode,q=z.nextSibling,Q=n,it=a.group,Rt.dragged=z,st={target:z,clientX:(e||t).clientX,clientY:(e||t).clientY},dt=st.clientX-d.left,ft=st.clientY-d.top,this._lastX=(e||t).clientX,this._lastY=(e||t).clientY,z.style["will-change"]="all",o=function(){U("delayEnded",r,{evt:t}),Rt.eventCanceled?r._onDrop():(r._disableDelayedDragEvents(),!u&&r.nativeDraggable&&(z.draggable=!0),r._triggerDragStart(t,e),$({sortable:r,name:"choose",originalEvent:t}),S(z,a.chosenClass,!0))},a.ignore.split(",").forEach((function(t){A(z,t.trim(),Ht)})),g(s,"dragover",jt),g(s,"mousemove",jt),g(s,"touchmove",jt),g(s,"mouseup",r._onDrop),g(s,"touchend",r._onDrop),g(s,"touchcancel",r._onDrop),u&&this.nativeDraggable&&(this.options.touchStartThreshold=4,z.draggable=!0),U("delayStart",this,{evt:t}),!a.delay||a.delayOnTouchOnly&&!e||this.nativeDraggable&&(c||l))o();else{if(Rt.eventCanceled)return void this._onDrop();g(s,"mouseup",r._disableDelayedDrag),g(s,"touchend",r._disableDelayedDrag),g(s,"touchcancel",r._disableDelayedDrag),g(s,"mousemove",r._delayedDragTouchMoveHandler),g(s,"touchmove",r._delayedDragTouchMoveHandler),a.supportPointer&&g(s,"pointermove",r._delayedDragTouchMoveHandler),r._dragStartTimer=setTimeout(o,a.delay)}}},_delayedDragTouchMoveHandler:function(t){var e=t.touches?t.touches[0]:t;Math.max(Math.abs(e.clientX-this._lastX),Math.abs(e.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))&&this._disableDelayedDrag()},_disableDelayedDrag:function(){z&&Ht(z),clearTimeout(this._dragStartTimer),this._disableDelayedDragEvents()},_disableDelayedDragEvents:function(){var t=this.el.ownerDocument;v(t,"mouseup",this._disableDelayedDrag),v(t,"touchend",this._disableDelayedDrag),v(t,"touchcancel",this._disableDelayedDrag),v(t,"mousemove",this._delayedDragTouchMoveHandler),v(t,"touchmove",this._delayedDragTouchMoveHandler),v(t,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function(t,e){e=e||"touch"==t.pointerType&&t,!this.nativeDraggable||e?this.options.supportPointer?g(document,"pointermove",this._onTouchMove):g(document,e?"touchmove":"mousemove",this._onTouchMove):(g(z,"dragend",this),g(K,"dragstart",this._onDragStart));try{document.selection?Yt((function(){document.selection.empty()})):window.getSelection().removeAllRanges()}catch(t){}},_dragStarted:function(t,e){if(bt=!1,K&&z){U("dragStarted",this,{evt:e}),this.nativeDraggable&&g(document,"dragover",Lt);var n=this.options;!t&&S(z,n.dragClass,!1),S(z,n.ghostClass,!0),Rt.active=this,t&&this._appendGhost(),$({sortable:this,name:"start",originalEvent:e})}else this._nulling()},_emulateDragOver:function(){if(lt){this._lastX=lt.clientX,this._lastY=lt.clientY,kt();for(var t=document.elementFromPoint(lt.clientX,lt.clientY),e=t;t&&t.shadowRoot&&(t=t.shadowRoot.elementFromPoint(lt.clientX,lt.clientY))!==e;)e=t;if(z.parentNode[F]._isOutsideThisEl(t),e)do{if(e[F]&&e[F]._onDragOver({clientX:lt.clientX,clientY:lt.clientY,target:t,rootEl:e})&&!this.options.dragoverBubble)break;t=e}while(e=e.parentNode);Pt()}},_onTouchMove:function(t){if(st){var e=this.options,n=e.fallbackTolerance,o=e.fallbackOffset,r=t.touches?t.touches[0]:t,i=W&&C(W,!0),a=W&&i&&i.a,s=W&&i&&i.d,l=Et&&mt&&N(mt),c=(r.clientX-st.clientX+o.x)/(a||1)+(l?l[0]-_t[0]:0)/(a||1),u=(r.clientY-st.clientY+o.y)/(s||1)+(l?l[1]-_t[1]:0)/(s||1);if(!Rt.active&&!bt){if(n&&Math.max(Math.abs(r.clientX-this._lastX),Math.abs(r.clientY-this._lastY))<n)return;this._onDragStart(t,!0)}if(W){i?(i.e+=c-(ct||0),i.f+=u-(ut||0)):i={a:1,b:0,c:0,d:1,e:c,f:u};var d="matrix(".concat(i.a,",").concat(i.b,",").concat(i.c,",").concat(i.d,",").concat(i.e,",").concat(i.f,")");_(W,"webkitTransform",d),_(W,"mozTransform",d),_(W,"msTransform",d),_(W,"transform",d),ct=c,ut=u,lt=r}t.cancelable&&t.preventDefault()}},_appendGhost:function(){if(!W){var t=this.options.fallbackOnBody?document.body:K,e=E(z,!0,Et,!0,t),n=this.options;if(Et){for(mt=t;"static"===_(mt,"position")&&"none"===_(mt,"transform")&&mt!==document;)mt=mt.parentNode;mt!==document.body&&mt!==document.documentElement?(mt===document&&(mt=T()),e.top+=mt.scrollTop,e.left+=mt.scrollLeft):mt=T(),_t=N(mt)}S(W=z.cloneNode(!0),n.ghostClass,!1),S(W,n.fallbackClass,!0),S(W,n.dragClass,!0),_(W,"transition",""),_(W,"transform",""),_(W,"box-sizing","border-box"),_(W,"margin",0),_(W,"top",e.top),_(W,"left",e.left),_(W,"width",e.width),_(W,"height",e.height),_(W,"opacity","0.8"),_(W,"position",Et?"absolute":"fixed"),_(W,"zIndex","100000"),_(W,"pointerEvents","none"),Rt.ghost=W,t.appendChild(W),_(W,"transform-origin",dt/parseInt(W.style.width)*100+"% "+ft/parseInt(W.style.height)*100+"%")}},_onDragStart:function(t,e){var n=this,o=t.dataTransfer,r=n.options;U("dragStart",this,{evt:t}),Rt.eventCanceled?this._onDrop():(U("setupClone",this),Rt.eventCanceled||((J=R(z)).draggable=!1,J.style["will-change"]="",this._hideClone(),S(J,this.options.chosenClass,!1),Rt.clone=J),n.cloneId=Yt((function(){U("clone",n),Rt.eventCanceled||(n.options.removeCloneOnHide||K.insertBefore(J,z),n._hideClone(),$({sortable:n,name:"clone"}))})),!e&&S(z,r.dragClass,!0),e?(yt=!0,n._loopId=setInterval(n._emulateDragOver,50)):(v(document,"mouseup",n._onDrop),v(document,"touchend",n._onDrop),v(document,"touchcancel",n._onDrop),o&&(o.effectAllowed="move",r.setData&&r.setData.call(n,o,z)),g(document,"drop",n),_(z,"transform","translateZ(0)")),bt=!0,n._dragStartId=Yt(n._dragStarted.bind(n,e,t)),g(document,"selectstart",n),pt=!0,d&&_(document.body,"user-select","none"))},_onDragOver:function(t){var e,n,o,r,i=this.el,s=t.target,l=this.options,c=l.group,u=Rt.active,d=it===c,f=l.sort,p=at||u,h=this,g=!1;if(!Ct){if(void 0!==t.preventDefault&&t.cancelable&&t.preventDefault(),s=y(s,l.draggable,i,!0),R("dragOver"),Rt.eventCanceled)return g;if(z.contains(t.target)||s.animated&&s.animatingX&&s.animatingY||h._ignoreWhileAnimating===s)return H(!1);if(yt=!1,u&&!l.disabled&&(d?f||(o=!K.contains(z)):at===this||(this.lastPutMode=it.checkPull(this,u,z,t))&&c.checkPut(this,u,z,t))){if(r="vertical"===this._getDirection(t,s),e=E(z),R("dragOverValid"),Rt.eventCanceled)return g;if(o)return G=K,B(),this._hideClone(),R("revert"),Rt.eventCanceled||(q?K.insertBefore(z,q):K.appendChild(z)),H(!0);var v=I(i,l.draggable);if(!v||function(t,e,n){var o=E(I(n.el,n.options.draggable));return e?t.clientX>o.right+10||t.clientX<=o.right&&t.clientY>o.bottom&&t.clientX>=o.left:t.clientX>o.right&&t.clientY>o.top||t.clientX<=o.right&&t.clientY>o.bottom+10}(t,r,this)&&!v.animated){if(v===z)return H(!1);if(v&&i===t.target&&(s=v),s&&(n=E(s)),!1!==Bt(K,i,z,e,s,n,t,!!s))return B(),i.appendChild(z),G=i,Z(),H(!0)}else if(s.parentNode===i){n=E(s);var m,b,x,w=z.parentNode!==i,C=!function(t,e,n){var o=n?t.left:t.top,r=n?t.right:t.bottom,i=n?t.width:t.height,a=n?e.left:e.top,s=n?e.right:e.bottom,l=n?e.width:e.height;return o===a||r===s||o+i/2===a+l/2}(z.animated&&z.toRect||e,s.animated&&s.toRect||n,r),A=r?"top":"left",T=D(s,"top","top")||D(z,"top","top"),O=T?T.scrollTop:void 0;if(ht!==s&&(b=n[A],wt=!1,St=!C&&l.invertSwap||w),m=function(t,e,n,o,r,i,a,s){var l=o?t.clientY:t.clientX,c=o?n.height:n.width,u=o?n.top:n.left,d=o?n.bottom:n.right,f=!1;if(!a)if(s&&vt<c*r){if(!wt&&(1===gt?l>u+c*i/2:l<d-c*i/2)&&(wt=!0),wt)f=!0;else if(1===gt?l<u+vt:l>d-vt)return-gt}else if(l>u+c*(1-r)/2&&l<d-c*(1-r)/2)return function(t){return M(z)<M(t)?1:-1}(e);return(f=f||a)&&(l<u+c*i/2||l>d-c*i/2)?l>u+c/2?1:-1:0}(t,s,n,r,C?1:l.swapThreshold,null==l.invertedSwapThreshold?l.swapThreshold:l.invertedSwapThreshold,St,ht===s),0!==m){var N=M(z);do{N-=m,x=G.children[N]}while(x&&("none"===_(x,"display")||x===W))}if(0===m||x===s)return H(!1);ht=s,gt=m;var k=s.nextElementSibling,P=!1,j=Bt(K,i,z,e,s,n,t,P=1===m);if(!1!==j)return 1!==j&&-1!==j||(P=1===j),Ct=!0,setTimeout(Ft,30),B(),P&&!k?i.appendChild(z):s.parentNode.insertBefore(z,P?k:s),T&&L(T,0,O-T.scrollTop),G=z.parentNode,void 0===b||St||(vt=Math.abs(b-E(s)[A])),Z(),H(!0)}if(i.contains(z))return H(!1)}return!1}function R(l,c){U(l,h,a({evt:t,isOwner:d,axis:r?"vertical":"horizontal",revert:o,dragRect:e,targetRect:n,canSort:f,fromSortable:p,target:s,completed:H,onMove:function(n,o){return Bt(K,i,z,e,n,E(n),t,o)},changed:Z},c))}function B(){R("dragOverAnimationCapture"),h.captureAnimationState(),h!==p&&p.captureAnimationState()}function H(e){return R("dragOverCompleted",{insertion:e}),e&&(d?u._hideClone():u._showClone(h),h!==p&&(S(z,at?at.options.ghostClass:u.options.ghostClass,!1),S(z,l.ghostClass,!0)),at!==h&&h!==Rt.active?at=h:h===Rt.active&&at&&(at=null),p===h&&(h._ignoreWhileAnimating=s),h.animateAll((function(){R("dragOverAnimationComplete"),h._ignoreWhileAnimating=null})),h!==p&&(p.animateAll(),p._ignoreWhileAnimating=null)),(s===z&&!z.animated||s===i&&!s.animated)&&(ht=null),l.dragoverBubble||t.rootEl||s===document||(z.parentNode[F]._isOutsideThisEl(t.target),!e&&jt(t)),!l.dragoverBubble&&t.stopPropagation&&t.stopPropagation(),g=!0}function Z(){nt=M(z),rt=M(z,l.draggable),$({sortable:h,name:"change",toEl:i,newIndex:nt,newDraggableIndex:rt,originalEvent:t})}},_ignoreWhileAnimating:null,_offMoveEvents:function(){v(document,"mousemove",this._onTouchMove),v(document,"touchmove",this._onTouchMove),v(document,"pointermove",this._onTouchMove),v(document,"dragover",jt),v(document,"mousemove",jt),v(document,"touchmove",jt)},_offUpEvents:function(){var t=this.el.ownerDocument;v(t,"mouseup",this._onDrop),v(t,"touchend",this._onDrop),v(t,"pointerup",this._onDrop),v(t,"touchcancel",this._onDrop),v(document,"selectstart",this)},_onDrop:function(t){var e=this.el,n=this.options;nt=M(z),rt=M(z,n.draggable),U("drop",this,{evt:t}),G=z&&z.parentNode,nt=M(z),rt=M(z,n.draggable),Rt.eventCanceled||(bt=!1,St=!1,wt=!1,clearInterval(this._loopId),clearTimeout(this._dragStartTimer),Vt(this.cloneId),Vt(this._dragStartId),this.nativeDraggable&&(v(document,"drop",this),v(e,"dragstart",this._onDragStart)),this._offMoveEvents(),this._offUpEvents(),d&&_(document.body,"user-select",""),_(z,"transform",""),t&&(pt&&(t.cancelable&&t.preventDefault(),!n.dropBubble&&t.stopPropagation()),W&&W.parentNode&&W.parentNode.removeChild(W),(K===G||at&&"clone"!==at.lastPutMode)&&J&&J.parentNode&&J.parentNode.removeChild(J),z&&(this.nativeDraggable&&v(z,"dragend",this),Ht(z),z.style["will-change"]="",pt&&!bt&&S(z,at?at.options.ghostClass:this.options.ghostClass,!1),S(z,this.options.chosenClass,!1),$({sortable:this,name:"unchoose",toEl:G,newIndex:null,newDraggableIndex:null,originalEvent:t}),K!==G?(nt>=0&&($({rootEl:G,name:"add",toEl:G,fromEl:K,originalEvent:t}),$({sortable:this,name:"remove",toEl:G,originalEvent:t}),$({rootEl:G,name:"sort",toEl:G,fromEl:K,originalEvent:t}),$({sortable:this,name:"sort",toEl:G,originalEvent:t})),at&&at.save()):nt!==et&&nt>=0&&($({sortable:this,name:"update",toEl:G,originalEvent:t}),$({sortable:this,name:"sort",toEl:G,originalEvent:t})),Rt.active&&(null!=nt&&-1!==nt||(nt=et,rt=ot),$({sortable:this,name:"end",toEl:G,originalEvent:t}),this.save())))),this._nulling()},_nulling:function(){U("nulling",this),K=z=G=W=q=J=Q=tt=st=lt=pt=nt=rt=et=ot=ht=gt=at=it=Rt.dragged=Rt.ghost=Rt.clone=Rt.active=null,At.forEach((function(t){t.checked=!0})),At.length=ct=ut=0},handleEvent:function(t){switch(t.type){case"drop":case"dragend":this._onDrop(t);break;case"dragenter":case"dragover":z&&(this._onDragOver(t),function(t){t.dataTransfer&&(t.dataTransfer.dropEffect="move"),t.cancelable&&t.preventDefault()}(t));break;case"selectstart":t.preventDefault()}},toArray:function(){for(var t,e=[],n=this.el.children,o=0,r=n.length,i=this.options;o<r;o++)y(t=n[o],i.draggable,this.el,!1)&&e.push(t.getAttribute(i.dataIdAttr)||Zt(t));return e},sort:function(t){var e={},n=this.el;this.toArray().forEach((function(t,o){var r=n.children[o];y(r,this.options.draggable,n,!1)&&(e[t]=r)}),this),t.forEach((function(t){e[t]&&(n.removeChild(e[t]),n.appendChild(e[t]))}))},save:function(){var t=this.options.store;t&&t.set&&t.set(this)},closest:function(t,e){return y(t,e||this.options.draggable,this.el,!1)},option:function(t,e){var n=this.options;if(void 0===e)return n[t];var o=V.modifyOption(this,t,e);n[t]=void 0!==o?o:e,"group"===t&&Nt(n)},destroy:function(){U("destroy",this);var t=this.el;t[F]=null,v(t,"mousedown",this._onTapStart),v(t,"touchstart",this._onTapStart),v(t,"pointerdown",this._onTapStart),this.nativeDraggable&&(v(t,"dragover",this),v(t,"dragenter",this)),Array.prototype.forEach.call(t.querySelectorAll("[draggable]"),(function(t){t.removeAttribute("draggable")})),this._onDrop(),this._disableDelayedDragEvents(),xt.splice(xt.indexOf(this.el),1),this.el=t=null},_hideClone:function(){if(!tt){if(U("hideClone",this),Rt.eventCanceled)return;_(J,"display","none"),this.options.removeCloneOnHide&&J.parentNode&&J.parentNode.removeChild(J),tt=!0}},_showClone:function(t){if("clone"===t.lastPutMode){if(tt){if(U("showClone",this),Rt.eventCanceled)return;K.contains(z)&&!this.options.group.revertClone?K.insertBefore(J,z):q?K.insertBefore(J,q):K.appendChild(J),this.options.group.revertClone&&this.animate(z,J),_(J,"display",""),tt=!1}}else this._hideClone()}},Tt&&g(document,"touchmove",(function(t){(Rt.active||bt)&&t.cancelable&&t.preventDefault()})),Rt.utils={on:g,off:v,css:_,find:A,is:function(t,e){return!!y(t,e,t,!1)},extend:function(t,e){if(t&&e)for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t},throttle:j,closest:y,toggleClass:S,clone:R,index:M,nextTick:Yt,cancelNextTick:Vt,detectDirection:Mt,getChild:O},Rt.get=function(t){return t[F]},Rt.mount=function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];e[0].constructor===Array&&(e=e[0]),e.forEach((function(t){if(!t.prototype||!t.prototype.constructor)throw"Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(t));t.utils&&(Rt.utils=a({},Rt.utils,t.utils)),V.mount(t)}))},Rt.create=function(t,e){return new Rt(t,e)},Rt.version="1.10.2";var Xt,Ut,$t,zt,Gt,Wt,Kt=[],qt=!1;function Qt(){Kt.forEach((function(t){clearInterval(t.pid)})),Kt=[]}function Jt(){clearInterval(Wt)}var te,ee=j((function(t,e,n,o){if(e.scroll){var r,i=(t.touches?t.touches[0]:t).clientX,a=(t.touches?t.touches[0]:t).clientY,s=e.scrollSensitivity,l=e.scrollSpeed,c=T(),u=!1;Ut!==n&&(Ut=n,Qt(),Xt=e.scroll,r=e.scrollFn,!0===Xt&&(Xt=k(n,!0)));var d=0,f=Xt;do{var p=f,h=E(p),g=h.top,v=h.bottom,m=h.left,b=h.right,y=h.width,x=h.height,w=void 0,S=void 0,C=p.scrollWidth,A=p.scrollHeight,D=_(p),O=p.scrollLeft,I=p.scrollTop;p===c?(w=y<C&&("auto"===D.overflowX||"scroll"===D.overflowX||"visible"===D.overflowX),S=x<A&&("auto"===D.overflowY||"scroll"===D.overflowY||"visible"===D.overflowY)):(w=y<C&&("auto"===D.overflowX||"scroll"===D.overflowX),S=x<A&&("auto"===D.overflowY||"scroll"===D.overflowY));var M=w&&(Math.abs(b-i)<=s&&O+y<C)-(Math.abs(m-i)<=s&&!!O),N=S&&(Math.abs(v-a)<=s&&I+x<A)-(Math.abs(g-a)<=s&&!!I);if(!Kt[d])for(var P=0;P<=d;P++)Kt[P]||(Kt[P]={});Kt[d].vx==M&&Kt[d].vy==N&&Kt[d].el===p||(Kt[d].el=p,Kt[d].vx=M,Kt[d].vy=N,clearInterval(Kt[d].pid),0==M&&0==N||(u=!0,Kt[d].pid=setInterval(function(){o&&0===this.layer&&Rt.active._onTouchMove(Gt);var e=Kt[this.layer].vy?Kt[this.layer].vy*l:0,n=Kt[this.layer].vx?Kt[this.layer].vx*l:0;"function"==typeof r&&"continue"!==r.call(Rt.dragged.parentNode[F],n,e,t,Gt,Kt[this.layer].el)||L(Kt[this.layer].el,n,e)}.bind({layer:d}),24))),d++}while(e.bubbleScroll&&f!==c&&(f=k(f,!1)));qt=u}}),30),ne=function(t){var e=t.originalEvent,n=t.putSortable,o=t.dragEl,r=t.activeSortable,i=t.dispatchSortableEvent,a=t.hideGhostForTarget,s=t.unhideGhostForTarget;if(e){var l=n||r;a();var c=e.changedTouches&&e.changedTouches.length?e.changedTouches[0]:e,u=document.elementFromPoint(c.clientX,c.clientY);s(),l&&!l.el.contains(u)&&(i("spill"),this.onSpill({dragEl:o,putSortable:n}))}};function oe(){}function re(){}function ie(){function t(){this.defaults={swapClass:"sortable-swap-highlight"}}return t.prototype={dragStart:function(t){var e=t.dragEl;te=e},dragOverValid:function(t){var e=t.completed,n=t.target,o=t.onMove,r=t.activeSortable,i=t.changed,a=t.cancel;if(r.options.swap){var s=this.sortable.el,l=this.options;if(n&&n!==s){var c=te;!1!==o(n)?(S(n,l.swapClass,!0),te=n):te=null,c&&c!==te&&S(c,l.swapClass,!1)}i(),e(!0),a()}},drop:function(t){var e,n,o,r,i,a,s=t.activeSortable,l=t.putSortable,c=t.dragEl,u=l||this.sortable,d=this.options;te&&S(te,d.swapClass,!1),te&&(d.swap||l&&l.options.swap)&&c!==te&&(u.captureAnimationState(),u!==s&&s.captureAnimationState(),n=te,i=(e=c).parentNode,a=n.parentNode,i&&a&&!i.isEqualNode(n)&&!a.isEqualNode(e)&&(o=M(e),r=M(n),i.isEqualNode(a)&&o<r&&r++,i.insertBefore(n,i.children[o]),a.insertBefore(e,a.children[r])),u.animateAll(),u!==s&&s.animateAll())},nulling:function(){te=null}},i(t,{pluginName:"swap",eventProperties:function(){return{swapItem:te}}})}oe.prototype={startIndex:null,dragStart:function(t){var e=t.oldDraggableIndex;this.startIndex=e},onSpill:function(t){var e=t.dragEl,n=t.putSortable;this.sortable.captureAnimationState(),n&&n.captureAnimationState();var o=O(this.sortable.el,this.startIndex,this.options);o?this.sortable.el.insertBefore(e,o):this.sortable.el.appendChild(e),this.sortable.animateAll(),n&&n.animateAll()},drop:ne},i(oe,{pluginName:"revertOnSpill"}),re.prototype={onSpill:function(t){var e=t.dragEl,n=t.putSortable||this.sortable;n.captureAnimationState(),e.parentNode&&e.parentNode.removeChild(e),n.animateAll()},drop:ne},i(re,{pluginName:"removeOnSpill"});var ae,se,le,ce,ue,de=[],fe=[],pe=!1,he=!1,ge=!1;function ve(){function t(t){for(var e in this)"_"===e.charAt(0)&&"function"==typeof this[e]&&(this[e]=this[e].bind(this));t.options.supportPointer?g(document,"pointerup",this._deselectMultiDrag):(g(document,"mouseup",this._deselectMultiDrag),g(document,"touchend",this._deselectMultiDrag)),g(document,"keydown",this._checkKeyDown),g(document,"keyup",this._checkKeyUp),this.defaults={selectedClass:"sortable-selected",multiDragKey:null,setData:function(e,n){var o="";de.length&&se===t?de.forEach((function(t,e){o+=(e?", ":"")+t.textContent})):o=n.textContent,e.setData("Text",o)}}}return t.prototype={multiDragKeyDown:!1,isMultiDrag:!1,delayStartGlobal:function(t){var e=t.dragEl;le=e},delayEnded:function(){this.isMultiDrag=~de.indexOf(le)},setupClone:function(t){var e=t.sortable,n=t.cancel;if(this.isMultiDrag){for(var o=0;o<de.length;o++)fe.push(R(de[o])),fe[o].sortableIndex=de[o].sortableIndex,fe[o].draggable=!1,fe[o].style["will-change"]="",S(fe[o],this.options.selectedClass,!1),de[o]===le&&S(fe[o],this.options.chosenClass,!1);e._hideClone(),n()}},clone:function(t){var e=t.sortable,n=t.rootEl,o=t.dispatchSortableEvent,r=t.cancel;this.isMultiDrag&&(this.options.removeCloneOnHide||de.length&&se===e&&(me(!0,n),o("clone"),r()))},showClone:function(t){var e=t.cloneNowShown,n=t.rootEl,o=t.cancel;this.isMultiDrag&&(me(!1,n),fe.forEach((function(t){_(t,"display","")})),e(),ue=!1,o())},hideClone:function(t){var e=this,n=(t.sortable,t.cloneNowHidden),o=t.cancel;this.isMultiDrag&&(fe.forEach((function(t){_(t,"display","none"),e.options.removeCloneOnHide&&t.parentNode&&t.parentNode.removeChild(t)})),n(),ue=!0,o())},dragStartGlobal:function(t){t.sortable,!this.isMultiDrag&&se&&se.multiDrag._deselectMultiDrag(),de.forEach((function(t){t.sortableIndex=M(t)})),de=de.sort((function(t,e){return t.sortableIndex-e.sortableIndex})),ge=!0},dragStarted:function(t){var e=this,n=t.sortable;if(this.isMultiDrag){if(this.options.sort&&(n.captureAnimationState(),this.options.animation)){de.forEach((function(t){t!==le&&_(t,"position","absolute")}));var o=E(le,!1,!0,!0);de.forEach((function(t){t!==le&&B(t,o)})),he=!0,pe=!0}n.animateAll((function(){he=!1,pe=!1,e.options.animation&&de.forEach((function(t){H(t)})),e.options.sort&&be()}))}},dragOver:function(t){var e=t.target,n=t.completed,o=t.cancel;he&&~de.indexOf(e)&&(n(!1),o())},revert:function(t){var e=t.fromSortable,n=t.rootEl,o=t.sortable,r=t.dragRect;de.length>1&&(de.forEach((function(t){o.addAnimationState({target:t,rect:he?E(t):r}),H(t),t.fromRect=r,e.removeAnimationState(t)})),he=!1,function(t,e){de.forEach((function(n,o){var r=e.children[n.sortableIndex+(t?Number(o):0)];r?e.insertBefore(n,r):e.appendChild(n)}))}(!this.options.removeCloneOnHide,n))},dragOverCompleted:function(t){var e=t.sortable,n=t.isOwner,o=t.insertion,r=t.activeSortable,i=t.parentEl,a=t.putSortable,s=this.options;if(o){if(n&&r._hideClone(),pe=!1,s.animation&&de.length>1&&(he||!n&&!r.options.sort&&!a)){var l=E(le,!1,!0,!0);de.forEach((function(t){t!==le&&(B(t,l),i.appendChild(t))})),he=!0}if(!n)if(he||be(),de.length>1){var c=ue;r._showClone(e),r.options.animation&&!ue&&c&&fe.forEach((function(t){r.addAnimationState({target:t,rect:ce}),t.fromRect=ce,t.thisAnimationDuration=null}))}else r._showClone(e)}},dragOverAnimationCapture:function(t){var e=t.dragRect,n=t.isOwner,o=t.activeSortable;if(de.forEach((function(t){t.thisAnimationDuration=null})),o.options.animation&&!n&&o.multiDrag.isMultiDrag){ce=i({},e);var r=C(le,!0);ce.top-=r.f,ce.left-=r.e}},dragOverAnimationComplete:function(){he&&(he=!1,be())},drop:function(t){var e=t.originalEvent,n=t.rootEl,o=t.parentEl,r=t.sortable,i=t.dispatchSortableEvent,a=t.oldIndex,s=t.putSortable,l=s||this.sortable;if(e){var c=this.options,u=o.children;if(!ge)if(c.multiDragKey&&!this.multiDragKeyDown&&this._deselectMultiDrag(),S(le,c.selectedClass,!~de.indexOf(le)),~de.indexOf(le))de.splice(de.indexOf(le),1),ae=null,X({sortable:r,rootEl:n,name:"deselect",targetEl:le,originalEvt:e});else{if(de.push(le),X({sortable:r,rootEl:n,name:"select",targetEl:le,originalEvt:e}),e.shiftKey&&ae&&r.el.contains(ae)){var d,f,p=M(ae),h=M(le);if(~p&&~h&&p!==h)for(h>p?(f=p,d=h):(f=h,d=p+1);f<d;f++)~de.indexOf(u[f])||(S(u[f],c.selectedClass,!0),de.push(u[f]),X({sortable:r,rootEl:n,name:"select",targetEl:u[f],originalEvt:e}))}else ae=le;se=l}if(ge&&this.isMultiDrag){if((o[F].options.sort||o!==n)&&de.length>1){var g=E(le),v=M(le,":not(."+this.options.selectedClass+")");if(!pe&&c.animation&&(le.thisAnimationDuration=null),l.captureAnimationState(),!pe&&(c.animation&&(le.fromRect=g,de.forEach((function(t){if(t.thisAnimationDuration=null,t!==le){var e=he?E(t):g;t.fromRect=e,l.addAnimationState({target:t,rect:e})}}))),be(),de.forEach((function(t){u[v]?o.insertBefore(t,u[v]):o.appendChild(t),v++})),a===M(le))){var m=!1;de.forEach((function(t){t.sortableIndex===M(t)||(m=!0)})),m&&i("update")}de.forEach((function(t){H(t)})),l.animateAll()}se=l}(n===o||s&&"clone"!==s.lastPutMode)&&fe.forEach((function(t){t.parentNode&&t.parentNode.removeChild(t)}))}},nullingGlobal:function(){this.isMultiDrag=ge=!1,fe.length=0},destroyGlobal:function(){this._deselectMultiDrag(),v(document,"pointerup",this._deselectMultiDrag),v(document,"mouseup",this._deselectMultiDrag),v(document,"touchend",this._deselectMultiDrag),v(document,"keydown",this._checkKeyDown),v(document,"keyup",this._checkKeyUp)},_deselectMultiDrag:function(t){if(!(void 0!==ge&&ge||se!==this.sortable||t&&y(t.target,this.options.draggable,this.sortable.el,!1)||t&&0!==t.button))for(;de.length;){var e=de[0];S(e,this.options.selectedClass,!1),de.shift(),X({sortable:this.sortable,rootEl:this.sortable.el,name:"deselect",targetEl:e,originalEvt:t})}},_checkKeyDown:function(t){t.key===this.options.multiDragKey&&(this.multiDragKeyDown=!0)},_checkKeyUp:function(t){t.key===this.options.multiDragKey&&(this.multiDragKeyDown=!1)}},i(t,{pluginName:"multiDrag",utils:{select:function(t){var e=t.parentNode[F];e&&e.options.multiDrag&&!~de.indexOf(t)&&(se&&se!==e&&(se.multiDrag._deselectMultiDrag(),se=e),S(t,e.options.selectedClass,!0),de.push(t))},deselect:function(t){var e=t.parentNode[F],n=de.indexOf(t);e&&e.options.multiDrag&&~n&&(S(t,e.options.selectedClass,!1),de.splice(n,1))}},eventProperties:function(){var t,e=this,n=[],o=[];return de.forEach((function(t){var r;n.push({multiDragElement:t,index:t.sortableIndex}),r=he&&t!==le?-1:he?M(t,":not(."+e.options.selectedClass+")"):M(t),o.push({multiDragElement:t,index:r})})),{items:(t=de,function(t){if(Array.isArray(t)){for(var e=0,n=new Array(t.length);e<t.length;e++)n[e]=t[e];return n}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()),clones:[].concat(fe),oldIndicies:n,newIndicies:o}},optionListeners:{multiDragKey:function(t){return"ctrl"===(t=t.toLowerCase())?t="Control":t.length>1&&(t=t.charAt(0).toUpperCase()+t.substr(1)),t}}})}function me(t,e){fe.forEach((function(n,o){var r=e.children[n.sortableIndex+(t?Number(o):0)];r?e.insertBefore(n,r):e.appendChild(n)}))}function be(){de.forEach((function(t){t!==le&&t.parentNode&&t.parentNode.removeChild(t)}))}Rt.mount(new function(){function t(){for(var t in this.defaults={scroll:!0,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:!0},this)"_"===t.charAt(0)&&"function"==typeof this[t]&&(this[t]=this[t].bind(this))}return t.prototype={dragStarted:function(t){var e=t.originalEvent;this.sortable.nativeDraggable?g(document,"dragover",this._handleAutoScroll):this.options.supportPointer?g(document,"pointermove",this._handleFallbackAutoScroll):e.touches?g(document,"touchmove",this._handleFallbackAutoScroll):g(document,"mousemove",this._handleFallbackAutoScroll)},dragOverCompleted:function(t){var e=t.originalEvent;this.options.dragOverBubble||e.rootEl||this._handleAutoScroll(e)},drop:function(){this.sortable.nativeDraggable?v(document,"dragover",this._handleAutoScroll):(v(document,"pointermove",this._handleFallbackAutoScroll),v(document,"touchmove",this._handleFallbackAutoScroll),v(document,"mousemove",this._handleFallbackAutoScroll)),Jt(),Qt(),clearTimeout(x),x=void 0},nulling:function(){Gt=Ut=Xt=qt=Wt=$t=zt=null,Kt.length=0},_handleFallbackAutoScroll:function(t){this._handleAutoScroll(t,!0)},_handleAutoScroll:function(t,e){var n=this,o=(t.touches?t.touches[0]:t).clientX,r=(t.touches?t.touches[0]:t).clientY,i=document.elementFromPoint(o,r);if(Gt=t,e||c||l||d){ee(t,this.options,i,e);var a=k(i,!0);!qt||Wt&&o===$t&&r===zt||(Wt&&Jt(),Wt=setInterval((function(){var i=k(document.elementFromPoint(o,r),!0);i!==a&&(a=i,Qt()),ee(t,n.options,i,e)}),10),$t=o,zt=r)}else{if(!this.options.bubbleScroll||k(i,!0)===T())return void Qt();ee(t,this.options,k(i,!1),!1)}}},i(t,{pluginName:"scroll",initializeByDefault:!0})}),Rt.mount(re,oe);const ye=Rt},9980:function(t,e,n){var o;"undefined"!=typeof self&&self,o=function(t){return function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s="fb15")}({"01f9":function(t,e,n){"use strict";var o=n("2d00"),r=n("5ca1"),i=n("2aba"),a=n("32e9"),s=n("84f2"),l=n("41a0"),c=n("7f20"),u=n("38fd"),d=n("2b4c")("iterator"),f=!([].keys&&"next"in[].keys()),p="keys",h="values",g=function(){return this};t.exports=function(t,e,n,v,m,b,y){l(n,e,v);var x,w,S,_=function(t){if(!f&&t in E)return E[t];switch(t){case p:case h:return function(){return new n(this,t)}}return function(){return new n(this,t)}},C=e+" Iterator",A=m==h,T=!1,E=t.prototype,D=E[d]||E["@@iterator"]||m&&E[m],O=D||_(m),I=m?A?_("entries"):O:void 0,M="Array"==e&&E.entries||D;if(M&&(S=u(M.call(new t)))!==Object.prototype&&S.next&&(c(S,C,!0),o||"function"==typeof S[d]||a(S,d,g)),A&&D&&D.name!==h&&(T=!0,O=function(){return D.call(this)}),o&&!y||!f&&!T&&E[d]||a(E,d,O),s[e]=O,s[C]=g,m)if(x={values:A?O:_(h),keys:b?O:_(p),entries:I},y)for(w in x)w in E||i(E,w,x[w]);else r(r.P+r.F*(f||T),e,x);return x}},"02f4":function(t,e,n){var o=n("4588"),r=n("be13");t.exports=function(t){return function(e,n){var i,a,s=String(r(e)),l=o(n),c=s.length;return l<0||l>=c?t?"":void 0:(i=s.charCodeAt(l))<55296||i>56319||l+1===c||(a=s.charCodeAt(l+1))<56320||a>57343?t?s.charAt(l):i:t?s.slice(l,l+2):a-56320+(i-55296<<10)+65536}}},"0390":function(t,e,n){"use strict";var o=n("02f4")(!0);t.exports=function(t,e,n){return e+(n?o(t,e).length:1)}},"0bfb":function(t,e,n){"use strict";var o=n("cb7c");t.exports=function(){var t=o(this),e="";return t.global&&(e+="g"),t.ignoreCase&&(e+="i"),t.multiline&&(e+="m"),t.unicode&&(e+="u"),t.sticky&&(e+="y"),e}},"0d58":function(t,e,n){var o=n("ce10"),r=n("e11e");t.exports=Object.keys||function(t){return o(t,r)}},1495:function(t,e,n){var o=n("86cc"),r=n("cb7c"),i=n("0d58");t.exports=n("9e1e")?Object.defineProperties:function(t,e){r(t);for(var n,a=i(e),s=a.length,l=0;s>l;)o.f(t,n=a[l++],e[n]);return t}},"214f":function(t,e,n){"use strict";n("b0c5");var o=n("2aba"),r=n("32e9"),i=n("79e5"),a=n("be13"),s=n("2b4c"),l=n("520a"),c=s("species"),u=!i((function(){var t=/./;return t.exec=function(){var t=[];return t.groups={a:"7"},t},"7"!=="".replace(t,"$<a>")})),d=function(){var t=/(?:)/,e=t.exec;t.exec=function(){return e.apply(this,arguments)};var n="ab".split(t);return 2===n.length&&"a"===n[0]&&"b"===n[1]}();t.exports=function(t,e,n){var f=s(t),p=!i((function(){var e={};return e[f]=function(){return 7},7!=""[t](e)})),h=p?!i((function(){var e=!1,n=/a/;return n.exec=function(){return e=!0,null},"split"===t&&(n.constructor={},n.constructor[c]=function(){return n}),n[f](""),!e})):void 0;if(!p||!h||"replace"===t&&!u||"split"===t&&!d){var g=/./[f],v=n(a,f,""[t],(function(t,e,n,o,r){return e.exec===l?p&&!r?{done:!0,value:g.call(e,n,o)}:{done:!0,value:t.call(n,e,o)}:{done:!1}})),m=v[0],b=v[1];o(String.prototype,t,m),r(RegExp.prototype,f,2==e?function(t,e){return b.call(t,this,e)}:function(t){return b.call(t,this)})}}},"230e":function(t,e,n){var o=n("d3f4"),r=n("7726").document,i=o(r)&&o(r.createElement);t.exports=function(t){return i?r.createElement(t):{}}},"23c6":function(t,e,n){var o=n("2d95"),r=n("2b4c")("toStringTag"),i="Arguments"==o(function(){return arguments}());t.exports=function(t){var e,n,a;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),r))?n:i?o(e):"Object"==(a=o(e))&&"function"==typeof e.callee?"Arguments":a}},2621:function(t,e){e.f=Object.getOwnPropertySymbols},"2aba":function(t,e,n){var o=n("7726"),r=n("32e9"),i=n("69a8"),a=n("ca5a")("src"),s=n("fa5b"),l="toString",c=(""+s).split(l);n("8378").inspectSource=function(t){return s.call(t)},(t.exports=function(t,e,n,s){var l="function"==typeof n;l&&(i(n,"name")||r(n,"name",e)),t[e]!==n&&(l&&(i(n,a)||r(n,a,t[e]?""+t[e]:c.join(String(e)))),t===o?t[e]=n:s?t[e]?t[e]=n:r(t,e,n):(delete t[e],r(t,e,n)))})(Function.prototype,l,(function(){return"function"==typeof this&&this[a]||s.call(this)}))},"2aeb":function(t,e,n){var o=n("cb7c"),r=n("1495"),i=n("e11e"),a=n("613b")("IE_PROTO"),s=function(){},l="prototype",c=function(){var t,e=n("230e")("iframe"),o=i.length;for(e.style.display="none",n("fab2").appendChild(e),e.src="javascript:",(t=e.contentWindow.document).open(),t.write("<script>document.F=Object<\/script>"),t.close(),c=t.F;o--;)delete c[l][i[o]];return c()};t.exports=Object.create||function(t,e){var n;return null!==t?(s[l]=o(t),n=new s,s[l]=null,n[a]=t):n=c(),void 0===e?n:r(n,e)}},"2b4c":function(t,e,n){var o=n("5537")("wks"),r=n("ca5a"),i=n("7726").Symbol,a="function"==typeof i;(t.exports=function(t){return o[t]||(o[t]=a&&i[t]||(a?i:r)("Symbol."+t))}).store=o},"2d00":function(t,e){t.exports=!1},"2d95":function(t,e){var n={}.toString;t.exports=function(t){return n.call(t).slice(8,-1)}},"2fdb":function(t,e,n){"use strict";var o=n("5ca1"),r=n("d2c8"),i="includes";o(o.P+o.F*n("5147")(i),"String",{includes:function(t){return!!~r(this,t,i).indexOf(t,arguments.length>1?arguments[1]:void 0)}})},"32e9":function(t,e,n){var o=n("86cc"),r=n("4630");t.exports=n("9e1e")?function(t,e,n){return o.f(t,e,r(1,n))}:function(t,e,n){return t[e]=n,t}},"38fd":function(t,e,n){var o=n("69a8"),r=n("4bf8"),i=n("613b")("IE_PROTO"),a=Object.prototype;t.exports=Object.getPrototypeOf||function(t){return t=r(t),o(t,i)?t[i]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?a:null}},"41a0":function(t,e,n){"use strict";var o=n("2aeb"),r=n("4630"),i=n("7f20"),a={};n("32e9")(a,n("2b4c")("iterator"),(function(){return this})),t.exports=function(t,e,n){t.prototype=o(a,{next:r(1,n)}),i(t,e+" Iterator")}},"456d":function(t,e,n){var o=n("4bf8"),r=n("0d58");n("5eda")("keys",(function(){return function(t){return r(o(t))}}))},4588:function(t,e){var n=Math.ceil,o=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?o:n)(t)}},4630:function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},"4bf8":function(t,e,n){var o=n("be13");t.exports=function(t){return Object(o(t))}},5147:function(t,e,n){var o=n("2b4c")("match");t.exports=function(t){var e=/./;try{"/./"[t](e)}catch(n){try{return e[o]=!1,!"/./"[t](e)}catch(t){}}return!0}},"520a":function(t,e,n){"use strict";var o,r,i=n("0bfb"),a=RegExp.prototype.exec,s=String.prototype.replace,l=a,c="lastIndex",u=(o=/a/,r=/b*/g,a.call(o,"a"),a.call(r,"a"),0!==o[c]||0!==r[c]),d=void 0!==/()??/.exec("")[1];(u||d)&&(l=function(t){var e,n,o,r,l=this;return d&&(n=new RegExp("^"+l.source+"$(?!\\s)",i.call(l))),u&&(e=l[c]),o=a.call(l,t),u&&o&&(l[c]=l.global?o.index+o[0].length:e),d&&o&&o.length>1&&s.call(o[0],n,(function(){for(r=1;r<arguments.length-2;r++)void 0===arguments[r]&&(o[r]=void 0)})),o}),t.exports=l},"52a7":function(t,e){e.f={}.propertyIsEnumerable},5537:function(t,e,n){var o=n("8378"),r=n("7726"),i="__core-js_shared__",a=r[i]||(r[i]={});(t.exports=function(t,e){return a[t]||(a[t]=void 0!==e?e:{})})("versions",[]).push({version:o.version,mode:n("2d00")?"pure":"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"})},"5ca1":function(t,e,n){var o=n("7726"),r=n("8378"),i=n("32e9"),a=n("2aba"),s=n("9b43"),l="prototype",c=function(t,e,n){var u,d,f,p,h=t&c.F,g=t&c.G,v=t&c.S,m=t&c.P,b=t&c.B,y=g?o:v?o[e]||(o[e]={}):(o[e]||{})[l],x=g?r:r[e]||(r[e]={}),w=x[l]||(x[l]={});for(u in g&&(n=e),n)f=((d=!h&&y&&void 0!==y[u])?y:n)[u],p=b&&d?s(f,o):m&&"function"==typeof f?s(Function.call,f):f,y&&a(y,u,f,t&c.U),x[u]!=f&&i(x,u,p),m&&w[u]!=f&&(w[u]=f)};o.core=r,c.F=1,c.G=2,c.S=4,c.P=8,c.B=16,c.W=32,c.U=64,c.R=128,t.exports=c},"5eda":function(t,e,n){var o=n("5ca1"),r=n("8378"),i=n("79e5");t.exports=function(t,e){var n=(r.Object||{})[t]||Object[t],a={};a[t]=e(n),o(o.S+o.F*i((function(){n(1)})),"Object",a)}},"5f1b":function(t,e,n){"use strict";var o=n("23c6"),r=RegExp.prototype.exec;t.exports=function(t,e){var n=t.exec;if("function"==typeof n){var i=n.call(t,e);if("object"!=typeof i)throw new TypeError("RegExp exec method returned something other than an Object or null");return i}if("RegExp"!==o(t))throw new TypeError("RegExp#exec called on incompatible receiver");return r.call(t,e)}},"613b":function(t,e,n){var o=n("5537")("keys"),r=n("ca5a");t.exports=function(t){return o[t]||(o[t]=r(t))}},"626a":function(t,e,n){var o=n("2d95");t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return"String"==o(t)?t.split(""):Object(t)}},6762:function(t,e,n){"use strict";var o=n("5ca1"),r=n("c366")(!0);o(o.P,"Array",{includes:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0)}}),n("9c6c")("includes")},6821:function(t,e,n){var o=n("626a"),r=n("be13");t.exports=function(t){return o(r(t))}},"69a8":function(t,e){var n={}.hasOwnProperty;t.exports=function(t,e){return n.call(t,e)}},"6a99":function(t,e,n){var o=n("d3f4");t.exports=function(t,e){if(!o(t))return t;var n,r;if(e&&"function"==typeof(n=t.toString)&&!o(r=n.call(t)))return r;if("function"==typeof(n=t.valueOf)&&!o(r=n.call(t)))return r;if(!e&&"function"==typeof(n=t.toString)&&!o(r=n.call(t)))return r;throw TypeError("Can't convert object to primitive value")}},7333:function(t,e,n){"use strict";var o=n("0d58"),r=n("2621"),i=n("52a7"),a=n("4bf8"),s=n("626a"),l=Object.assign;t.exports=!l||n("79e5")((function(){var t={},e={},n=Symbol(),o="abcdefghijklmnopqrst";return t[n]=7,o.split("").forEach((function(t){e[t]=t})),7!=l({},t)[n]||Object.keys(l({},e)).join("")!=o}))?function(t,e){for(var n=a(t),l=arguments.length,c=1,u=r.f,d=i.f;l>c;)for(var f,p=s(arguments[c++]),h=u?o(p).concat(u(p)):o(p),g=h.length,v=0;g>v;)d.call(p,f=h[v++])&&(n[f]=p[f]);return n}:l},7726:function(t,e){var n=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},"77f1":function(t,e,n){var o=n("4588"),r=Math.max,i=Math.min;t.exports=function(t,e){return(t=o(t))<0?r(t+e,0):i(t,e)}},"79e5":function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},"7f20":function(t,e,n){var o=n("86cc").f,r=n("69a8"),i=n("2b4c")("toStringTag");t.exports=function(t,e,n){t&&!r(t=n?t:t.prototype,i)&&o(t,i,{configurable:!0,value:e})}},8378:function(t,e){var n=t.exports={version:"2.6.5"};"number"==typeof __e&&(__e=n)},"84f2":function(t,e){t.exports={}},"86cc":function(t,e,n){var o=n("cb7c"),r=n("c69a"),i=n("6a99"),a=Object.defineProperty;e.f=n("9e1e")?Object.defineProperty:function(t,e,n){if(o(t),e=i(e,!0),o(n),r)try{return a(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(t[e]=n.value),t}},"9b43":function(t,e,n){var o=n("d8e8");t.exports=function(t,e,n){if(o(t),void 0===e)return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,o){return t.call(e,n,o)};case 3:return function(n,o,r){return t.call(e,n,o,r)}}return function(){return t.apply(e,arguments)}}},"9c6c":function(t,e,n){var o=n("2b4c")("unscopables"),r=Array.prototype;null==r[o]&&n("32e9")(r,o,{}),t.exports=function(t){r[o][t]=!0}},"9def":function(t,e,n){var o=n("4588"),r=Math.min;t.exports=function(t){return t>0?r(o(t),9007199254740991):0}},"9e1e":function(t,e,n){t.exports=!n("79e5")((function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}))},a352:function(e,n){e.exports=t},a481:function(t,e,n){"use strict";var o=n("cb7c"),r=n("4bf8"),i=n("9def"),a=n("4588"),s=n("0390"),l=n("5f1b"),c=Math.max,u=Math.min,d=Math.floor,f=/\$([$&`']|\d\d?|<[^>]*>)/g,p=/\$([$&`']|\d\d?)/g;n("214f")("replace",2,(function(t,e,n,h){return[function(o,r){var i=t(this),a=null==o?void 0:o[e];return void 0!==a?a.call(o,i,r):n.call(String(i),o,r)},function(t,e){var r=h(n,t,this,e);if(r.done)return r.value;var d=o(t),f=String(this),p="function"==typeof e;p||(e=String(e));var v=d.global;if(v){var m=d.unicode;d.lastIndex=0}for(var b=[];;){var y=l(d,f);if(null===y)break;if(b.push(y),!v)break;""===String(y[0])&&(d.lastIndex=s(f,i(d.lastIndex),m))}for(var x,w="",S=0,_=0;_<b.length;_++){y=b[_];for(var C=String(y[0]),A=c(u(a(y.index),f.length),0),T=[],E=1;E<y.length;E++)T.push(void 0===(x=y[E])?x:String(x));var D=y.groups;if(p){var O=[C].concat(T,A,f);void 0!==D&&O.push(D);var I=String(e.apply(void 0,O))}else I=g(C,f,A,T,D,e);A>=S&&(w+=f.slice(S,A)+I,S=A+C.length)}return w+f.slice(S)}];function g(t,e,o,i,a,s){var l=o+t.length,c=i.length,u=p;return void 0!==a&&(a=r(a),u=f),n.call(s,u,(function(n,r){var s;switch(r.charAt(0)){case"$":return"$";case"&":return t;case"`":return e.slice(0,o);case"'":return e.slice(l);case"<":s=a[r.slice(1,-1)];break;default:var u=+r;if(0===u)return n;if(u>c){var f=d(u/10);return 0===f?n:f<=c?void 0===i[f-1]?r.charAt(1):i[f-1]+r.charAt(1):n}s=i[u-1]}return void 0===s?"":s}))}}))},aae3:function(t,e,n){var o=n("d3f4"),r=n("2d95"),i=n("2b4c")("match");t.exports=function(t){var e;return o(t)&&(void 0!==(e=t[i])?!!e:"RegExp"==r(t))}},ac6a:function(t,e,n){for(var o=n("cadf"),r=n("0d58"),i=n("2aba"),a=n("7726"),s=n("32e9"),l=n("84f2"),c=n("2b4c"),u=c("iterator"),d=c("toStringTag"),f=l.Array,p={CSSRuleList:!0,CSSStyleDeclaration:!1,CSSValueList:!1,ClientRectList:!1,DOMRectList:!1,DOMStringList:!1,DOMTokenList:!0,DataTransferItemList:!1,FileList:!1,HTMLAllCollection:!1,HTMLCollection:!1,HTMLFormElement:!1,HTMLSelectElement:!1,MediaList:!0,MimeTypeArray:!1,NamedNodeMap:!1,NodeList:!0,PaintRequestList:!1,Plugin:!1,PluginArray:!1,SVGLengthList:!1,SVGNumberList:!1,SVGPathSegList:!1,SVGPointList:!1,SVGStringList:!1,SVGTransformList:!1,SourceBufferList:!1,StyleSheetList:!0,TextTrackCueList:!1,TextTrackList:!1,TouchList:!1},h=r(p),g=0;g<h.length;g++){var v,m=h[g],b=p[m],y=a[m],x=y&&y.prototype;if(x&&(x[u]||s(x,u,f),x[d]||s(x,d,m),l[m]=f,b))for(v in o)x[v]||i(x,v,o[v],!0)}},b0c5:function(t,e,n){"use strict";var o=n("520a");n("5ca1")({target:"RegExp",proto:!0,forced:o!==/./.exec},{exec:o})},be13:function(t,e){t.exports=function(t){if(null==t)throw TypeError("Can't call method on  "+t);return t}},c366:function(t,e,n){var o=n("6821"),r=n("9def"),i=n("77f1");t.exports=function(t){return function(e,n,a){var s,l=o(e),c=r(l.length),u=i(a,c);if(t&&n!=n){for(;c>u;)if((s=l[u++])!=s)return!0}else for(;c>u;u++)if((t||u in l)&&l[u]===n)return t||u||0;return!t&&-1}}},c649:function(t,e,n){"use strict";(function(t){n.d(e,"c",(function(){return c})),n.d(e,"a",(function(){return s})),n.d(e,"b",(function(){return i})),n.d(e,"d",(function(){return l})),n("a481");var o,r,i="undefined"!=typeof window?window.console:t.console,a=/-(\w)/g,s=(o=function(t){return t.replace(a,(function(t,e){return e?e.toUpperCase():""}))},r=Object.create(null),function(t){return r[t]||(r[t]=o(t))});function l(t){null!==t.parentElement&&t.parentElement.removeChild(t)}function c(t,e,n){var o=0===n?t.children[0]:t.children[n-1].nextSibling;t.insertBefore(e,o)}}).call(this,n("c8ba"))},c69a:function(t,e,n){t.exports=!n("9e1e")&&!n("79e5")((function(){return 7!=Object.defineProperty(n("230e")("div"),"a",{get:function(){return 7}}).a}))},c8ba:function(t,e){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(t){"object"==typeof window&&(n=window)}t.exports=n},ca5a:function(t,e){var n=0,o=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++n+o).toString(36))}},cadf:function(t,e,n){"use strict";var o=n("9c6c"),r=n("d53b"),i=n("84f2"),a=n("6821");t.exports=n("01f9")(Array,"Array",(function(t,e){this._t=a(t),this._i=0,this._k=e}),(function(){var t=this._t,e=this._k,n=this._i++;return!t||n>=t.length?(this._t=void 0,r(1)):r(0,"keys"==e?n:"values"==e?t[n]:[n,t[n]])}),"values"),i.Arguments=i.Array,o("keys"),o("values"),o("entries")},cb7c:function(t,e,n){var o=n("d3f4");t.exports=function(t){if(!o(t))throw TypeError(t+" is not an object!");return t}},ce10:function(t,e,n){var o=n("69a8"),r=n("6821"),i=n("c366")(!1),a=n("613b")("IE_PROTO");t.exports=function(t,e){var n,s=r(t),l=0,c=[];for(n in s)n!=a&&o(s,n)&&c.push(n);for(;e.length>l;)o(s,n=e[l++])&&(~i(c,n)||c.push(n));return c}},d2c8:function(t,e,n){var o=n("aae3"),r=n("be13");t.exports=function(t,e,n){if(o(e))throw TypeError("String#"+n+" doesn't accept regex!");return String(r(t))}},d3f4:function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},d53b:function(t,e){t.exports=function(t,e){return{value:e,done:!!t}}},d8e8:function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t}},e11e:function(t,e){t.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},f559:function(t,e,n){"use strict";var o=n("5ca1"),r=n("9def"),i=n("d2c8"),a="startsWith",s=""[a];o(o.P+o.F*n("5147")(a),"String",{startsWith:function(t){var e=i(this,t,a),n=r(Math.min(arguments.length>1?arguments[1]:void 0,e.length)),o=String(t);return s?s.call(e,o,n):e.slice(n,n+o.length)===o}})},f6fd:function(t,e){!function(t){var e="currentScript",n=t.getElementsByTagName("script");e in t||Object.defineProperty(t,e,{get:function(){try{throw new Error}catch(o){var t,e=(/.*at [^\(]*\((.*):.+:.+\)$/gi.exec(o.stack)||[!1])[1];for(t in n)if(n[t].src==e||"interactive"==n[t].readyState)return n[t];return null}}})}(document)},f751:function(t,e,n){var o=n("5ca1");o(o.S+o.F,"Object",{assign:n("7333")})},fa5b:function(t,e,n){t.exports=n("5537")("native-function-to-string",Function.toString)},fab2:function(t,e,n){var o=n("7726").document;t.exports=o&&o.documentElement},fb15:function(t,e,n){"use strict";var o;function r(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}function i(t,e){if(t){if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?r(t,e):void 0}}function a(t){return function(t){if(Array.isArray(t))return r(t)}(t)||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||i(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}n.r(e),"undefined"!=typeof window&&(n("f6fd"),(o=window.document.currentScript)&&(o=o.src.match(/(.+\/)[^/]+\.js(\?.*)?$/))&&(n.p=o[1])),n("f751"),n("f559"),n("ac6a"),n("cadf"),n("456d"),n("6762"),n("2fdb");var s=n("a352"),l=n.n(s),c=n("c649");function u(t,e){var n=this;this.$nextTick((function(){return n.$emit(t.toLowerCase(),e)}))}function d(t){var e=this;return function(n){null!==e.realList&&e["onDrag"+t](n),u.call(e,t,n)}}function f(t){return["transition-group","TransitionGroup"].includes(t)}function p(t,e,n){return t[n]||(e[n]?e[n]():void 0)}var h=["Start","Add","Remove","Update","End"],g=["Choose","Unchoose","Sort","Filter","Clone"],v=["Move"].concat(h,g).map((function(t){return"on"+t})),m=null,b={name:"draggable",inheritAttrs:!1,props:{options:Object,list:{type:Array,required:!1,default:null},value:{type:Array,required:!1,default:null},noTransitionOnDrag:{type:Boolean,default:!1},clone:{type:Function,default:function(t){return t}},element:{type:String,default:"div"},tag:{type:String,default:null},move:{type:Function,default:null},componentData:{type:Object,required:!1,default:null}},data:function(){return{transitionMode:!1,noneFunctionalComponentMode:!1}},render:function(t){var e=this.$slots.default;this.transitionMode=function(t){if(!t||1!==t.length)return!1;var e,n,o=(e=t,n=1,function(t){if(Array.isArray(t))return t}(e)||function(t,e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t)){var n=[],o=!0,r=!1,i=void 0;try{for(var a,s=t[Symbol.iterator]();!(o=(a=s.next()).done)&&(n.push(a.value),!e||n.length!==e);o=!0);}catch(t){r=!0,i=t}finally{try{o||null==s.return||s.return()}finally{if(r)throw i}}return n}}(e,n)||i(e,n)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}())[0].componentOptions;return!!o&&f(o.tag)}(e);var n=function(t,e,n){var o=0,r=0,i=p(e,n,"header");i&&(o=i.length,t=t?[].concat(a(i),a(t)):a(i));var s=p(e,n,"footer");return s&&(r=s.length,t=t?[].concat(a(t),a(s)):a(s)),{children:t,headerOffset:o,footerOffset:r}}(e,this.$slots,this.$scopedSlots),o=n.children,r=n.headerOffset,s=n.footerOffset;this.headerOffset=r,this.footerOffset=s;var l=function(t,e){var n=null,o=function(t,e){n=function(t,e,n){return void 0===n||((t=t||{})[e]=n),t}(n,t,e)};if(o("attrs",Object.keys(t).filter((function(t){return"id"===t||t.startsWith("data-")})).reduce((function(e,n){return e[n]=t[n],e}),{})),!e)return n;var r=e.on,i=e.props,a=e.attrs;return o("on",r),o("props",i),Object.assign(n.attrs,a),n}(this.$attrs,this.componentData);return t(this.getTag(),l,o)},created:function(){null!==this.list&&null!==this.value&&c.b.error("Value and list props are mutually exclusive! Please set one or another."),"div"!==this.element&&c.b.warn("Element props is deprecated please use tag props instead. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#element-props"),void 0!==this.options&&c.b.warn("Options props is deprecated, add sortable options directly as vue.draggable item, or use v-bind. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#options-props")},mounted:function(){var t=this;if(this.noneFunctionalComponentMode=this.getTag().toLowerCase()!==this.$el.nodeName.toLowerCase()&&!this.getIsFunctional(),this.noneFunctionalComponentMode&&this.transitionMode)throw new Error("Transition-group inside component is not supported. Please alter tag value or remove transition-group. Current tag value: ".concat(this.getTag()));var e={};h.forEach((function(n){e["on"+n]=d.call(t,n)})),g.forEach((function(n){e["on"+n]=u.bind(t,n)}));var n=Object.keys(this.$attrs).reduce((function(e,n){return e[Object(c.a)(n)]=t.$attrs[n],e}),{}),o=Object.assign({},this.options,n,e,{onMove:function(e,n){return t.onDragMove(e,n)}});!("draggable"in o)&&(o.draggable=">*"),this._sortable=new l.a(this.rootContainer,o),this.computeIndexes()},beforeDestroy:function(){void 0!==this._sortable&&this._sortable.destroy()},computed:{rootContainer:function(){return this.transitionMode?this.$el.children[0]:this.$el},realList:function(){return this.list?this.list:this.value}},watch:{options:{handler:function(t){this.updateOptions(t)},deep:!0},$attrs:{handler:function(t){this.updateOptions(t)},deep:!0},realList:function(){this.computeIndexes()}},methods:{getIsFunctional:function(){var t=this._vnode.fnOptions;return t&&t.functional},getTag:function(){return this.tag||this.element},updateOptions:function(t){for(var e in t){var n=Object(c.a)(e);-1===v.indexOf(n)&&this._sortable.option(n,t[e])}},getChildrenNodes:function(){if(this.noneFunctionalComponentMode)return this.$children[0].$slots.default;var t=this.$slots.default;return this.transitionMode?t[0].child.$slots.default:t},computeIndexes:function(){var t=this;this.$nextTick((function(){t.visibleIndexes=function(t,e,n,o){if(!t)return[];var r=t.map((function(t){return t.elm})),i=e.length-o,s=a(e).map((function(t,e){return e>=i?r.length:r.indexOf(t)}));return n?s.filter((function(t){return-1!==t})):s}(t.getChildrenNodes(),t.rootContainer.children,t.transitionMode,t.footerOffset)}))},getUnderlyingVm:function(t){var e,n,o=(e=this.getChildrenNodes()||[],n=t,e.map((function(t){return t.elm})).indexOf(n));return-1===o?null:{index:o,element:this.realList[o]}},getUnderlyingPotencialDraggableComponent:function(t){var e=t.__vue__;return e&&e.$options&&f(e.$options._componentTag)?e.$parent:!("realList"in e)&&1===e.$children.length&&"realList"in e.$children[0]?e.$children[0]:e},emitChanges:function(t){var e=this;this.$nextTick((function(){e.$emit("change",t)}))},alterList:function(t){if(this.list)t(this.list);else{var e=a(this.value);t(e),this.$emit("input",e)}},spliceList:function(){var t=arguments;this.alterList((function(e){return e.splice.apply(e,a(t))}))},updatePosition:function(t,e){this.alterList((function(n){return n.splice(e,0,n.splice(t,1)[0])}))},getRelatedContextFromMoveEvent:function(t){var e=t.to,n=t.related,o=this.getUnderlyingPotencialDraggableComponent(e);if(!o)return{component:o};var r=o.realList,i={list:r,component:o};if(e!==n&&r&&o.getUnderlyingVm){var a=o.getUnderlyingVm(n);if(a)return Object.assign(a,i)}return i},getVmIndex:function(t){var e=this.visibleIndexes,n=e.length;return t>n-1?n:e[t]},getComponent:function(){return this.$slots.default[0].componentInstance},resetTransitionData:function(t){if(this.noTransitionOnDrag&&this.transitionMode){this.getChildrenNodes()[t].data=null;var e=this.getComponent();e.children=[],e.kept=void 0}},onDragStart:function(t){this.context=this.getUnderlyingVm(t.item),t.item._underlying_vm_=this.clone(this.context.element),m=t.item},onDragAdd:function(t){var e=t.item._underlying_vm_;if(void 0!==e){Object(c.d)(t.item);var n=this.getVmIndex(t.newIndex);this.spliceList(n,0,e),this.computeIndexes();var o={element:e,newIndex:n};this.emitChanges({added:o})}},onDragRemove:function(t){if(Object(c.c)(this.rootContainer,t.item,t.oldIndex),"clone"!==t.pullMode){var e=this.context.index;this.spliceList(e,1);var n={element:this.context.element,oldIndex:e};this.resetTransitionData(e),this.emitChanges({removed:n})}else Object(c.d)(t.clone)},onDragUpdate:function(t){Object(c.d)(t.item),Object(c.c)(t.from,t.item,t.oldIndex);var e=this.context.index,n=this.getVmIndex(t.newIndex);this.updatePosition(e,n);var o={element:this.context.element,oldIndex:e,newIndex:n};this.emitChanges({moved:o})},updateProperty:function(t,e){t.hasOwnProperty(e)&&(t[e]+=this.headerOffset)},computeFutureIndex:function(t,e){if(!t.element)return 0;var n=a(e.to.children).filter((function(t){return"none"!==t.style.display})),o=n.indexOf(e.related),r=t.component.getVmIndex(o);return-1===n.indexOf(m)&&e.willInsertAfter?r+1:r},onDragMove:function(t,e){var n=this.move;if(!n||!this.realList)return!0;var o=this.getRelatedContextFromMoveEvent(t),r=this.context,i=this.computeFutureIndex(o,t);return Object.assign(r,{futureIndex:i}),n(Object.assign({},t,{relatedContext:o,draggedContext:r}),e)},onDragEnd:function(){this.computeIndexes(),m=null}}};"undefined"!=typeof window&&"Vue"in window&&window.Vue.component("draggable",b);var y=b;e.default=y}}).default},t.exports=o(n(31715))},42761:t=>{"use strict";t.exports="data:image/svg+xml;base64,PCEtLSBUaGlzIGljb24gaXMgcGFydCBvZiBNYXRlcmlhbCBVSSBJY29ucy4gQ29weXJpZ2h0IDIwMjAgR29vZ2xlIEluYy4sIEFwYWNoZS0yLjAgTGljZW5zZSAtLT4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxNiAxNiI+PHBhdGggZD0iTS00LTRoMjR2MjRILTRWLTR6IiBmaWxsPSJub25lIi8+PHBhdGggZD0iTTggMEMzLjYgMCAwIDMuNiAwIDhzMy42IDggOCA4IDgtMy42IDgtOC0zLjYtOC04LTh6IiBmaWxsPSIjZWQ0ODRjIi8+PHBhdGggZD0iTTUgNi41aDZjLjggMCAxLjUuNyAxLjUgMS41cy0uNyAxLjUtMS41IDEuNUg1Yy0uOCAwLTEuNS0uNy0xLjUtMS41UzQuMiA2LjUgNSA2LjV6IiBmaWxsPSIjZmRmZmZmIi8+PC9zdmc+Cg=="},87210:t=>{"use strict";t.exports="data:image/svg+xml;base64,PCEtLSBUaGlzIGljb24gaXMgcGFydCBvZiBNYXRlcmlhbCBVSSBJY29ucy4gQ29weXJpZ2h0IDIwMjAgR29vZ2xlIEluYy4sIEFwYWNoZS0yLjAgTGljZW5zZSAtLT4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxNiAxNiI+PHBhdGggZD0iTTQuOCAxMS4yaDYuNFY0LjhINC44djYuNHpNOCAwQzMuNiAwIDAgMy42IDAgOHMzLjYgOCA4IDggOC0zLjYgOC04LTMuNi04LTgtOHoiIGZpbGw9IiM0OWIzODIiLz48L3N2Zz4K"},94659:t=>{"use strict";t.exports="data:image/svg+xml;base64,PCEtLSBUaGlzIGljb24gaXMgcGFydCBvZiBNYXRlcmlhbCBVSSBJY29ucy4gQ29weXJpZ2h0IDIwMjAgR29vZ2xlIEluYy4sIEFwYWNoZS0yLjAgTGljZW5zZSAtLT4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxNiAxNiI+PHBhdGggZmlsbD0ibm9uZSIgZD0iTS00LTRoMjR2MjRILTR6Ii8+PHBhdGggZD0iTTYuOS4xQzMgLjYtLjEgNC0uMSA4YzAgNC40IDMuNiA4IDggOCA0IDAgNy40LTMgOC02LjktMS4yIDEuMy0yLjkgMi4xLTQuNyAyLjEtMy41IDAtNi40LTIuOS02LjQtNi40IDAtMS45LjgtMy42IDIuMS00Ljd6IiBmaWxsPSIjZjRhMzMxIi8+PC9zdmc+Cg=="}},o={};function r(t){var e=o[t];if(void 0!==e)return e.exports;var i=o[t]={id:t,loaded:!1,exports:{}};return n[t].call(i.exports,i,i.exports,r),i.loaded=!0,i.exports}r.m=n,e=[],r.O=(t,n,o,i)=>{if(!n){var a=1/0;for(u=0;u<e.length;u++){n=e[u][0],o=e[u][1],i=e[u][2];for(var s=!0,l=0;l<n.length;l++)(!1&i||a>=i)&&Object.keys(r.O).every((t=>r.O[t](n[l])))?n.splice(l--,1):(s=!1,i<a&&(a=i));if(s){e.splice(u--,1);var c=o();void 0!==c&&(t=c)}}return t}i=i||0;for(var u=e.length;u>0&&e[u-1][2]>i;u--)e[u]=e[u-1];e[u]=[n,o,i]},r.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return r.d(e,{a:e}),e},r.d=(t,e)=>{for(var n in e)r.o(e,n)&&!r.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},r.e=()=>Promise.resolve(),r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),r.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),r.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},r.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),r.j=1104,(()=>{r.b=document.baseURI||self.location.href;var t={1104:0};r.O.j=e=>0===t[e];var e=(e,n)=>{var o,i,a=n[0],s=n[1],l=n[2],c=0;if(a.some((e=>0!==t[e]))){for(o in s)r.o(s,o)&&(r.m[o]=s[o]);if(l)var u=l(r)}for(e&&e(n);c<a.length;c++)i=a[c],r.o(t,i)&&t[i]&&t[i][0](),t[i]=0;return r.O(u)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),r.nc=void 0;var i=r.O(void 0,[7874],(()=>r(35594)));i=r.O(i)})();
//# sourceMappingURL=settings-vue-settings-admin-ai.js.map?v=f4e426a47a3d6728cd6c